<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) exit( 'No direct script access allowed' );
/**
* ------------------------------------------------------------------------------------------------
* Author area element map
* ------------------------------------------------------------------------------------------------
*/

if( ! function_exists( 'woodmart_get_vc_map_author_area' ) ) {
	function woodmart_get_vc_map_author_area() {
		return array(
			'name' => esc_html__( 'Author area', 'studiare-plus' ),
			'base' => 'author_area',
			'category' => function_exists( 'woodmart_get_tab_title_category_for_wpb' ) ? woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ) : esc_html__( 'Theme elements', 'studiare-plus' ),
			'description' => esc_html__( 'Widget for author information', 'studiare-plus' ),
			'icon' => WOODMART_ASSETS . '/images/vc-icon/author-area.svg',
			'params' =>  woodmart_get_author_area_params()
		);
	}
}

if( ! function_exists( 'woodmart_get_author_area_params' ) ) {
	function woodmart_get_author_area_params() {
		return apply_filters( 'woodmart_get_author_area_params', array(
			array(
				'param_name' => 'woodmart_css_id',
				'type'       => 'woodmart_css_id',
			),
			/**
			* Image
			*/
			array(
				'type' => 'woodmart_title_divider',
				'holder' => 'div',
				'title' => esc_html__( 'Image', 'studiare-plus' ),
				'param_name' => 'image_divider'
			),	
			array(
				'type' => 'attach_image',
				'heading' => esc_html__( 'Image', 'studiare-plus' ),
				'param_name' => 'image',
				'value' => '',
				'hint' => esc_html__( 'Select image from media library.', 'studiare-plus' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Image size', 'studiare-plus' ),
				'param_name' => 'img_size',
				'hint' => esc_html__( 'Enter image size. Example: \'thumbnail\', \'medium\', \'large\', \'full\' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.', 'studiare-plus' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			/**
			* Content
			*/
			array(
				'type' => 'woodmart_title_divider',
				'holder' => 'div',
				'title' => esc_html__( 'Content', 'studiare-plus' ),
				'param_name' => 'content_divider'
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Title', 'studiare-plus' ),
				'param_name' => 'title',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Author name', 'studiare-plus' ),
				'param_name' => 'author_name',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'textarea_html',
				'holder' => 'div',
				'heading' => esc_html__( 'Author bio', 'studiare-plus' ),
				'param_name' => 'content',
				'hint' => esc_html__( 'Write down a few words about the author.', 'studiare-plus' )
			),
			/**
			* Style
			*/
			array(
				'type' => 'woodmart_title_divider',
				'holder' => 'div',
				'title' => esc_html__( 'Style', 'studiare-plus' ),
				'param_name' => 'style_divider'
			),
			array(
				'type' => 'woodmart_image_select',
				'heading' => esc_html__( 'Text alignment', 'studiare-plus' ),
				'param_name' => 'alignment',
				'value' => array( 
					esc_html__( 'Left', 'studiare-plus' ) => 'left',
					esc_html__( 'Center', 'studiare-plus' ) => 'center',
					esc_html__( 'Right', 'studiare-plus' ) => 'right',
				),
				'images_value' => array(
					'center' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
					'left' => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
					'right' => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
				),
				'std' => 'left',
				'wood_tooltip' => true,
				'hint' => esc_html__( 'Select image alignment.', 'studiare-plus' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column title-align',
			),
			array(
				'type' => 'woodmart_button_set',
				'heading' => esc_html__( 'Color Scheme', 'studiare-plus' ),
				'param_name' => 'woodmart_color_scheme',
				'value' => array(
					esc_html__( 'Inherit', 'studiare-plus' ) => '',
					esc_html__( 'Light', 'studiare-plus' ) => 'light',
					esc_html__( 'Dark', 'studiare-plus' ) => 'dark',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			/**
			* Link
			*/
			array(
				'type' => 'woodmart_title_divider',
				'holder' => 'div',
				'title' => esc_html__( 'Link', 'studiare-plus' ),
				'param_name' => 'link_divider'
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'Author link', 'studiare-plus'),
				'param_name' => 'link',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Link text', 'studiare-plus'),
				'param_name' => 'link_text',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			/**
			* Extra
			*/
			array(
				'type' => 'woodmart_title_divider',
				'holder' => 'div',
				'title' => esc_html__( 'Extra options', 'studiare-plus' ),
				'param_name' => 'extra_divider'
			),
			( function_exists( 'vc_map_add_css_animation' ) ) ? vc_map_add_css_animation( true ) : '',
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'studiare-plus' ),
				'param_name' => 'el_class',
				'hint' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' )
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'js_composer' ),
			),
			function_exists( 'woodmart_get_vc_responsive_spacing_map' ) ? woodmart_get_vc_responsive_spacing_map() : '',
		) );
	}
}
