<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) exit( 'No direct script access allowed' );
/**
* ------------------------------------------------------------------------------------------------
*  AJAX search element map
* ------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'woodmart_get_vc_map_ajax_search' ) ) {
	function woodmart_get_vc_map_ajax_search() {
		return array(
			'name'        => esc_html__( 'AJAX Search', 'studiare-plus' ),
			'description' => esc_html__( 'Shows AJAX search form', 'studiare-plus' ),
			'base'        => 'woodmart_ajax_search',
			'category'    => woodmart_get_tab_title_category_for_wpb( esc_html__( 'Theme elements', 'studiare-plus' ) ),
			'icon'        => WOODMART_ASSETS . '/images/vc-icon/ajax-search.svg',
			'params'      => array(
				array(
					'type'       => 'woodmart_css_id',
					'param_name' => 'woodmart_css_id',
				),
				/**
				 * Search results
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Search results', 'studiare-plus' ),
					'param_name' => 'results_divider',
				),
				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Number results to show', 'studiare-plus' ),
					'param_name'       => 'number',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Search post type', 'studiare-plus' ),
					'param_name'       => 'search_post_type',
					'value'            => array(
						esc_html__( 'Product', 'studiare-plus' ) => 'product',
						esc_html__( 'Post', 'studiare-plus' ) => 'post',
						esc_html__( 'Portfolio', 'studiare-plus' ) => 'portfolio',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Show price', 'studiare-plus' ),
					'param_name'       => 'price',
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 1,
					'dependency'       => array(
						'element' => 'search_post_type',
						'value'   => 'product',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Show thumbnail', 'studiare-plus' ),
					'param_name'       => 'thumbnail',
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 1,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Show category', 'studiare-plus' ),
					'param_name'       => 'category',
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 1,
					'dependency'       => array(
						'element' => 'search_post_type',
						'value'   => 'product',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_button_set',
					'heading'          => esc_html__( 'Categories selector style', 'studiare-plus' ),
					'param_name'       => 'cat_selector_style',
					'value'            => array(
						esc_html__( 'Default', 'studiare-plus' ) => 'default',
						esc_html__( 'Bordered', 'studiare-plus' ) => 'bordered',
						esc_html__( 'Separated', 'studiare-plus' ) => 'separated',
					),
					'std'              => 'bordered',
					'dependency'       => array(
						'element' => 'category',
						'value'   => '1',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type'             => 'woodmart_switch',
					'heading'          => esc_html__( 'Include categories in search', 'studiare-plus' ),
					'param_name'       => 'include_cat_search',
					'true_state'       => 1,
					'false_state'      => 0,
					'default'          => 0,
					'dependency'       => array(
						'element' => 'search_post_type',
						'value'   => 'product',
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				/**
				 * Style
				 */
				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Form', 'studiare-plus' ),
					'param_name' => 'style_divider',
				),
				array(
					'heading'          => esc_html__( 'Style', 'studiare-plus' ),
					'type'             => 'woodmart_image_select',
					'param_name'       => 'form_style',
					'value'            => array(
						esc_html__( 'Style 1', 'studiare-plus' ) => 'default',
						esc_html__( 'Style 2', 'studiare-plus' ) => 'with-bg',
						esc_html__( 'Style 3', 'studiare-plus' ) => 'with-bg-2',
						esc_html__( 'Style 4', 'studiare-plus' ) => '4',
					),
					'images_value'     => array(
						'default'   => WOODMART_ASSETS_IMAGES . '/header-builder/search/default.jpg',
						'with-bg'   => WOODMART_ASSETS_IMAGES . '/header-builder/search/with-bg.jpg',
						'with-bg-2' => WOODMART_ASSETS_IMAGES . '/header-builder/search/with-bg-2.jpg',
						'4'         => WOODMART_ASSETS_IMAGES . '/header-builder/search/fourth.jpg',
					),
					'std'              => 'default',
					'wood_tooltip'     => true,
					'edit_field_class' => 'vc_col-sm-12 vc_column wd-form-style',
				),
				array(
					'heading'          => esc_html__( 'Form height', 'studiare-plus' ),
					'type'             => 'wd_slider',
					'param_name'       => 'form_height',
					'devices'          => array(
						'desktop' => array(
							'unit'  => 'px',
							'value' => '',
						),
						'tablet'  => array(
							'unit'  => 'px',
							'value' => '',
						),
						'mobile'  => array(
							'unit'  => 'px',
							'value' => '',
						),
					),
					'range'            => array(
						'px' => array(
							'min'  => 30,
							'max'  => 100,
							'step' => 1,
						),
					),
					'selectors'        => array(
						'{{WRAPPER}} .searchform' => array(
							'--wd-form-height: {{VALUE}}{{UNIT}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-12 vc_column',
				),
				array(
					'type'       => 'woodmart_button_set',
					'heading'    => esc_html__( 'Color Scheme', 'studiare-plus' ),
					'param_name' => 'woodmart_color_scheme',
					'value'      => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Light', 'studiare-plus' ) => 'light',
						esc_html__( 'Dark', 'studiare-plus' )  => 'dark',
					),
				),
				array(
					'heading'          => esc_html__( 'Text color', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'form_color',
					'selectors'        => array(
						'{{WRAPPER}} .searchform' => array(
							'--wd-form-color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Placeholder color', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'form_placeholder_color',
					'selectors'        => array(
						'{{WRAPPER}} .searchform' => array(
							'--wd-form-placeholder-color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Border color', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'form_brd_color',
					'selectors'        => array(
						'{{WRAPPER}} .searchform' => array(
							'--wd-form-brd-color: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Border color focus', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'form_brd_color_focus',
					'selectors'        => array(
						'{{WRAPPER}} .searchform' => array(
							'--wd-form-brd-color-focus: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'          => esc_html__( 'Background color', 'studiare-plus' ),
					'type'             => 'wd_colorpicker',
					'param_name'       => 'form_bg',
					'selectors'        => array(
						'{{WRAPPER}} .searchform' => array(
							'--wd-form-bg: {{VALUE}};',
						),
					),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'heading'       => esc_html__( 'Form shape', 'studiare-plus' ),
					'type'          => 'wd_select',
					'param_name'    => 'form_shape',
					'selectors'     => array(
						'{{WRAPPER}}' => array(
							'--wd-form-brd-radius: {{VALUE}}px;',
						),
					),
					'devices'       => array(
						'desktop' => array(
							'value' => '',
						),
					),
					'value'         => array(
						esc_html__( 'Inherit', 'studiare-plus' ) => '',
						esc_html__( 'Square', 'studiare-plus' ) => '0',
						esc_html__( 'Rounded', 'studiare-plus' ) => '5',
						esc_html__( 'Round', 'studiare-plus' )   => '35',
					),
					'generate_zero' => true,
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),

				array(
					'type'       => 'woodmart_title_divider',
					'holder'     => 'div',
					'title'      => esc_html__( 'Extra options', 'studiare-plus' ),
					'param_name' => 'extra_options_divider',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra class name', 'studiare-plus' ),
					'param_name' => 'el_class',
					'hint'       => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'studiare-plus' ),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'CSS box', 'studiare-plus' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design Options', 'js_composer' ),
				),
				woodmart_get_vc_responsive_spacing_map(),
			),
		);
	}
}
