<?php
namespace XTS\Elementor;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit;

class Expert_Widget extends Widget_Base {

    public function get_name() {
        return 'wd_expert';
    }

    public function get_title() {
        return esc_html__( 'متخصصین', 'studiare-plus' );
    }

    public function get_icon() {
        return 'wd-icon-blog';
    }

    public function get_categories() {
        return [ 'wd-elements' ];
    }

    protected function register_controls() {

        // کنترل تعداد نوشته ها
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__( 'تنظیمات محتوا', 'studiare-plus' ),
            ]
        );

        $this->add_control(
            'posts_count',
            [
                'label' => esc_html__( 'تعداد نوشته‌ها', 'studiare-plus' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 20,
                'step' => 1,
                'default' => 4,
            ]
        );

        // کنترل تعداد ستون ها
        $this->add_control(
            'columns',
            [
                'label' => esc_html__( 'تعداد ستون‌ها', 'studiare-plus' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'یک ستون',
                    '2' => 'دو ستون',
                    '3' => 'سه ستون',
                ],
                'default' => '2',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $posts_count = $settings['posts_count'];
        $columns = $settings['columns'];

        // query پست تایپ expert
        $args = [
            'post_type' => 'expert',
            'posts_per_page' => $posts_count,
            'post_status' => 'publish',
        ];

        $expert_query = new \WP_Query($args);

        if($expert_query->have_posts()) :

            // کلاس CSS داینامیک برای ستون ها
            $column_class = 'expert-columns-' . $columns;

            echo '<div class="expert-widget-wrapper ' . esc_attr($column_class) . '">';

            while($expert_query->have_posts()) : $expert_query->the_post();
                get_template_part('content', 'expert');
            endwhile;

            echo '</div>';

            wp_reset_postdata();
        endif;
    }
}

Plugin::instance()->widgets_manager->register( new Expert_Widget() );

