<?php
/**
 * Social buttons map.
 */

namespace XTS\Elementor;

use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Elementor widget that inserts an embeddable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Social extends Widget_Base {
	/**
	 * Get widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'wd_social_buttons';
	}

	/**
	 * Get widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Social buttons', 'studiare-plus' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'wd-icon-social';
	}

	/**
	 * Get widget categories.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'wd-elements' );
	}

	/**
	 * Register the widget controls.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		/**
		 * Content tab.
		 */

		/**
		 * General settings.
		 */
		$this->start_controls_section(
			'general_content_section',
			array(
				'label' => esc_html__( 'General', 'studiare-plus' ),
			)
		);

		$this->add_control(
			'show_label',
			array(
				'label'        => esc_html__( 'Label', 'studiare-plus' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'no',
				'label_on'     => esc_html__( 'On', 'studiare-plus' ),
				'label_off'    => esc_html__( 'Off', 'studiare-plus' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'label_text',
			array(
				'label'     => esc_html__( 'Label text', 'studiare-plus' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__( 'Share: ', 'studiare-plus' ),
				'condition' => array(
					'show_label' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'type',
			array(
				'label'   => esc_html__( 'Type', 'studiare-plus' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'share'  => esc_html__( 'Share', 'studiare-plus' ),
					'follow' => esc_html__( 'Follow', 'studiare-plus' ),
				),
				'default' => 'share',
			)
		);

		$this->add_control(
			'social_links_source',
			array(
				'label'     => esc_html__( 'Social links source', 'studiare-plus' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					'theme_settings' => esc_html__( 'Theme settings', 'studiare-plus' ),
					'custom'         => esc_html__( 'Custom', 'studiare-plus' ),
				),
				'default'   => 'theme_settings',
				'condition' => array(
					'type' => array( 'follow' ),
				),
			)
		);

		$this->end_controls_section();

		/**
		 * Links to social profiles.
		 */
		$this->start_controls_section(
			'social_links_content_section',
			array(
				'label'     => esc_html__( 'Links to social profiles', 'studiare-plus' ),
				'condition' => array(
					'type'                => array( 'follow' ),
					'social_links_source' => array( 'custom' ),
				),
			)
		);

		$this->add_control(
			'fb_link',
			array(
				'label'   => esc_html__( 'Facebook link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'twitter_link',
			array(
				'label'   => esc_html__( 'X link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'bluesky_link',
			array(
				'label'   => esc_html__( 'Bluesky link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'isntagram_link',
			array(
				'label'   => esc_html__( 'Instagram link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'threads_link',
			array(
				'label'   => esc_html__( 'Threads link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'pinterest_link',
			array(
				'label'   => esc_html__( 'Pinterest link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'youtube_link',
			array(
				'label'   => esc_html__( 'YouTube link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'tumblr_link',
			array(
				'label'   => esc_html__( 'Tumblr link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'linkedin_link',
			array(
				'label'   => esc_html__( 'LinkedIn link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'vimeo_link',
			array(
				'label'   => esc_html__( 'Vimeo link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'flickr_link',
			array(
				'label'   => esc_html__( 'Flickr link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'github_link',
			array(
				'label'   => esc_html__( 'Github link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'dribbble_link',
			array(
				'label'   => esc_html__( 'Dribbble link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'behance_link',
			array(
				'label'   => esc_html__( 'Behance link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'soundcloud_link',
			array(
				'label'   => esc_html__( 'SoundCloud link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'spotify_link',
			array(
				'label'   => esc_html__( 'Spotify link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'whatsapp_link',
			array(
				'label'   => esc_html__( 'WhatsApp link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'snapchat_link',
			array(
				'label'   => esc_html__( 'Snapchat link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'tg_link',
			array(
				'label'   => esc_html__( 'Telegram link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'viber_link',
			array(
				'label'   => esc_html__( 'Viber link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'tiktok_link',
			array(
				'label'   => esc_html__( 'TikTok link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'discord_link',
			array(
				'label'   => esc_html__( 'Discord link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'yelp_link',
			array(
				'label'   => esc_html__( 'Yelp link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'vk_link',
			array(
				'label'   => esc_html__( 'VK link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'ok_link',
			array(
				'label'   => esc_html__( 'OK link', 'studiare-plus' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		/**
		 * Style tab.
		 */

		/**
		 * General settings.
		 */
		$this->start_controls_section(
			'general_style_section',
			array(
				'label' => esc_html__( 'General', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'     => esc_html__( 'Layout', 'studiare-plus' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					''        => esc_html__( 'Default', 'studiare-plus' ),
					'justify' => esc_html__( 'Justify', 'studiare-plus' ),
					'inline'  => esc_html__( 'Inline', 'studiare-plus' ),
				),
				'default'   => '',
				'condition' => array(
					'show_label' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'align',
			array(
				'label'   => esc_html__( 'Align', 'studiare-plus' ),
				'type'    => 'wd_buttons',
				'options' => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'studiare-plus' ),
						'image' => WOODMART_ASSETS_IMAGES . '/settings/align/left.jpg',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'studiare-plus' ),
						'image' => WOODMART_ASSETS_IMAGES . '/settings/align/center.jpg',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'studiare-plus' ),
						'image' => WOODMART_ASSETS_IMAGES . '/settings/align/right.jpg',
					),
				),
				'default' => 'center',
			)
		);

		$this->end_controls_section();

		/**
		 * Icons settings.
		 */
		$this->start_controls_section(
			'icons_style_section',
			array(
				'label' => esc_html__( 'Icons', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'style',
			array(
				'label'   => esc_html__( 'Style', 'studiare-plus' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'default'     => esc_html__( 'Default', 'studiare-plus' ),
					'simple'      => esc_html__( 'Simple', 'studiare-plus' ),
					'colored'     => esc_html__( 'Colored', 'studiare-plus' ),
					'colored-alt' => esc_html__( 'Colored alternative', 'studiare-plus' ),
					'bordered'    => esc_html__( 'Bordered', 'studiare-plus' ),
					'primary'     => esc_html__( 'Primary color', 'studiare-plus' ),
				),
				'default' => 'default',
			)
		);

		$this->add_control(
			'form',
			array(
				'label'   => esc_html__( 'Shape', 'studiare-plus' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'circle'  => esc_html__( 'Circle', 'studiare-plus' ),
					'square'  => esc_html__( 'Square', 'studiare-plus' ),
					'rounded' => esc_html__( 'Rounded', 'studiare-plus' ),
				),
				'default' => 'circle',
			)
		);

		$this->add_control(
			'size',
			array(
				'label'   => esc_html__( 'Size', 'studiare-plus' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'default' => esc_html__( 'Default', 'studiare-plus' ),
					'small'   => esc_html__( 'Small', 'studiare-plus' ),
					'large'   => esc_html__( 'Large', 'studiare-plus' ),
				),
				'default' => 'default',
			)
		);

		$this->add_control(
			'color',
			array(
				'label'   => esc_html__( 'Color', 'studiare-plus' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'dark'  => esc_html__( 'Dark', 'studiare-plus' ),
					'light' => esc_html__( 'Light', 'studiare-plus' ),
				),
				'default' => 'dark',
			)
		);

		$this->end_controls_section();

		/**
		 * Label settings.
		 */
		$this->start_controls_section(
			'label_style_section',
			array(
				'label'     => esc_html__( 'Label', 'studiare-plus' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_label' => array( 'yes' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'label'     => esc_html__( 'Typography', 'studiare-plus' ),
				'name'      => 'title_typography',
				'selector'  => '{{WRAPPER}} .wd-social-icons .wd-label',
				'condition' => array(
					'show_label' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'label_color',
			array(
				'label'     => esc_html__( 'Label color', 'studiare-plus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .wd-social-icons .wd-label' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'show_label' => array( 'yes' ),
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = wp_parse_args(
			$this->get_settings_for_display(),
			array(
				'elementor'           => true,
				'layout'              => '',
				'social_links_source' => 'theme_settings',
				// Label settings.
				'show_label'          => 'no',
				'label_text'          => esc_html__( 'Share: ', 'studiare-plus' ),
				'is_element'          => true,
			)
		);

		woodmart_shortcode_social( $settings );
	}
}

Plugin::instance()->widgets_manager->register( new Social() );
