<?php
if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}

use XTS\Admin\Modules\Options;

/**
 * General.
 */
Options::add_section(
	array(
		'id'       => 'general_parent_section',
		'name'     => esc_html__( 'General', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-home',
	)
);

Options::add_section(
	array(
		'id'       => 'general_layout_section',
		'parent'   => 'general_parent_section',
		'name'     => esc_html__( 'Layout', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-home',
	)
);

Options::add_section(
	array(
		'id'       => 'header_banner_section',
		'parent'   => 'general_parent_section',
		'name'     => esc_html__( 'Header banner', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-home',
	)
);

Options::add_section(
	array(
		'id'       => 'promo_popup_section',
		'parent'   => 'general_parent_section',
		'name'     => esc_html__( 'Promo popup', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-home',
	)
);

Options::add_section(
	array(
		'id'       => 'age_verify_section',
		'parent'   => 'general_parent_section',
		'name'     => esc_html__( 'Age verify popup', 'studiare-plus' ),
		'priority' => 40,
		'icon'     => 'xts-i-home',
	)
);

Options::add_section(
	array(
		'id'       => 'cookie_section',
		'parent'   => 'general_parent_section',
		'name'     => esc_html__( 'Cookie law info', 'studiare-plus' ),
		'priority' => 50,
		'icon'     => 'xts-i-home',
	)
);

Options::add_section(
	array(
		'id'       => 'general_navbar_section',
		'parent'   => 'general_parent_section',
		'name'     => esc_html__( 'Mobile bottom navbar', 'studiare-plus' ),
		'priority' => 60,
		'icon'     => 'xts-i-home',
	)
);

Options::add_section(
	array(
		'id'       => 'general_search',
		'parent'   => 'general_parent_section',
		'name'     => esc_html__( 'Search', 'studiare-plus' ),
		'priority' => 70,
		'icon'     => 'xts-i-home',
	)
);

/**
 * Page title.
 */
Options::add_section(
	array(
		'id'       => 'page_title_section',
		'name'     => esc_html__( 'Page title', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-page-title',
	)
);

/**
 * Footer.
 */
Options::add_section(
	array(
		'id'       => 'general_footer_section',
		'name'     => esc_html__( 'Footer', 'studiare-plus' ),
		'priority' => 40,
		'icon'     => 'xts-i-footer',
	)
);

Options::add_section(
	array(
		'id'       => 'footer_section',
		'parent'   => 'general_footer_section',
		'name'     => esc_html__( 'Footer', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-footer',
	)
);

Options::add_section(
	array(
		'id'       => 'copyrights_section',
		'parent'   => 'general_footer_section',
		'name'     => esc_html__( 'Copyrights', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-footer',
	)
);

Options::add_section(
	array(
		'id'       => 'prefooter_section',
		'parent'   => 'general_footer_section',
		'name'     => esc_html__( 'Prefooter', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-footer',
	)
);

/**
 * Typography.
 */
Options::add_section(
	array(
		'id'       => 'general_typography_section',
		'name'     => esc_html__( 'Typography', 'studiare-plus' ),
		'priority' => 50,
		'icon'     => 'xts-i-typography',
	)
);

Options::add_section(
	array(
		'id'       => 'typography_section',
		'parent'   => 'general_typography_section',
		'name'     => esc_html__( 'Basic', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-typography',
	)
);

Options::add_section(
	array(
		'id'       => 'advanced_typography_section',
		'parent'   => 'general_typography_section',
		'name'     => esc_html__( 'Advanced', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-typography',
	)
);

Options::add_section(
	array(
		'id'       => 'custom_fonts_section',
		'parent'   => 'general_typography_section',
		'name'     => esc_html__( 'Custom fonts', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-typography',
	)
);

Options::add_section(
	array(
		'id'       => 'icons_fonts_section',
		'parent'   => 'general_typography_section',
		'name'     => esc_html__( 'Icon fonts', 'studiare-plus' ),
		'priority' => 40,
		'icon'     => 'xts-i-typography',
	)
);

Options::add_section(
	array(
		'id'       => 'typekit_section',
		'parent'   => 'general_typography_section',
		'name'     => esc_html__( 'Adobe fonts', 'studiare-plus' ),
		'priority' => 50,
		'icon'     => 'xts-i-typography',
	)
);

/**
 * Styles and colors.
 */
Options::add_section(
	array(
		'id'       => 'general_styles_section',
		'name'     => esc_html__( 'Styles and colors', 'studiare-plus' ),
		'priority' => 60,
		'icon'     => 'xts-i-brush',
	)
);

Options::add_section(
	array(
		'id'       => 'styles_section',
		'parent'   => 'general_styles_section',
		'name'     => esc_html__( 'Styles', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-brush',
	)
);

Options::add_section(
	array(
		'id'       => 'colors_section',
		'parent'   => 'general_styles_section',
		'name'     => esc_html__( 'Colors', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-brush',
	)
);

Options::add_section(
	array(
		'id'       => 'pages_bg_section',
		'parent'   => 'general_styles_section',
		'name'     => esc_html__( 'Pages background', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-brush',
	)
);

Options::add_section(
	array(
		'id'       => 'buttons_section',
		'parent'   => 'general_styles_section',
		'name'     => esc_html__( 'Buttons', 'studiare-plus' ),
		'priority' => 40,
		'icon'     => 'xts-i-brush',
	)
);

Options::add_section(
	array(
		'id'       => 'forms_section',
		'parent'   => 'general_styles_section',
		'name'     => esc_html__( 'Forms', 'studiare-plus' ),
		'priority' => 50,
		'icon'     => 'xts-i-brush',
	)
);

Options::add_section(
	array(
		'id'       => 'notices_section',
		'parent'   => 'general_styles_section',
		'name'     => esc_html__( 'Notices', 'studiare-plus' ),
		'priority' => 60,
		'icon'     => 'xts-i-brush',
	)
);

Options::add_section(
	array(
		'id'       => 'general_carousel',
		'parent'   => 'general_styles_section',
		'name'     => esc_html__( 'Carousel', 'studiare-plus' ),
		'priority' => 70,
		'icon'     => 'xts-i-brush',
	)
);

Options::add_section(
	array(
		'id'       => 'general_links',
		'parent'   => 'general_styles_section',
		'name'     => esc_html__( 'Links', 'studiare-plus' ),
		'priority' => 70,
		'icon'     => 'xts-i-brush',
	)
);

/**
 * Blog.
 */
Options::add_section(
	array(
		'id'       => 'general_blog_section',
		'name'     => esc_html__( 'Blog', 'studiare-plus' ),
		'priority' => 70,
		'icon'     => 'xts-i-book-edit',
	)
);

Options::add_section(
	array(
		'id'       => 'blog_archive_section',
		'name'     => esc_html__( 'Blog archive', 'studiare-plus' ),
		'parent'   => 'general_blog_section',
		'priority' => 10,
		'icon'     => 'xts-i-book-edit',
	)
);

Options::add_section(
	array(
		'id'       => 'blog_singe_post_section',
		'name'     => esc_html__( 'Single post', 'studiare-plus' ),
		'parent'   => 'general_blog_section',
		'priority' => 20,
		'icon'     => 'xts-i-book-edit',
	)
);

/**
 * course and teacher.
 */
Options::add_section(
	array(
		'id'       => 'course_section',
		'name'     => esc_html__( 'فروش دوره', 'studiare-plus' ),
		'priority' => 79,
		'icon'     => 'xts-i-archive',
	)
);


/**
 * Experts of academy.
 */
Options::add_section(
	array(
		'id'       => 'expert_section',
		'name'     => esc_html__( 'متخصصین', 'studiare-plus' ),
		'priority' => 80,
		'icon'     => 'xts-i-social',
	)
);


/**
 * Portfolio.
 */
Options::add_section(
	array(
		'id'       => 'general_portfolio_section',
		'name'     => esc_html__( 'Portfolio', 'studiare-plus' ),
		'priority' => 81,
		'icon'     => 'xts-i-portfolio',
	)
);

Options::add_section(
	array(
		'id'       => 'portfolio_section',
		'name'     => esc_html__( 'Portfolio', 'studiare-plus' ),
		'parent'   => 'general_portfolio_section',
		'priority' => 10,
		'icon'     => 'xts-i-portfolio',
	)
);

Options::add_section(
	array(
		'id'       => 'portfolio_archive_section',
		'name'     => esc_html__( 'Portfolio archive', 'studiare-plus' ),
		'parent'   => 'general_portfolio_section',
		'priority' => 20,
		'icon'     => 'xts-i-portfolio',
	)
);

Options::add_section(
	array(
		'id'       => 'portfolio_singe_project_section',
		'name'     => esc_html__( 'Single project', 'studiare-plus' ),
		'parent'   => 'general_portfolio_section',
		'priority' => 30,
		'icon'     => 'xts-i-portfolio',
	)
);

/**
 * Shop.
 */
Options::add_section(
	array(
		'id'       => 'general_shop_section',
		'name'     => esc_html__( 'Shop', 'studiare-plus' ),
		'priority' => 90,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'shop_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Shop', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'variable_products_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Variable products', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'product_labels_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Product labels', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'brands_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Brands', 'studiare-plus' ),
		'priority' => 40,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'quick_view_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Quick view', 'studiare-plus' ),
		'priority' => 50,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'compare_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Compare', 'studiare-plus' ),
		'priority' => 60,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'wishlist_section',
		'name'     => esc_html__( 'Wishlist', 'studiare-plus' ),
		'parent'   => 'general_shop_section',
		'priority' => 70,
		'icon'     => 'xts-i-cart',
		'class'    => 'xts-preset-section-disabled',
	)
);

Options::add_section(
	array(
		'id'       => 'waitlist_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Waitlist', 'studiare-plus' ),
		'priority' => 80,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'cart_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Cart', 'studiare-plus' ),
		'priority' => 90,
	)
);

Options::add_section(
	array(
		'id'       => 'checkout_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Checkout', 'studiare-plus' ),
		'priority' => 100,
		'class'    => 'xts-preset-section-disabled',
	)
);

Options::add_section(
	array(
		'id'       => 'thank_you_page_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Thank you page', 'studiare-plus' ),
		'priority' => 110,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'bought_together_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Frequently bought together', 'studiare-plus' ),
		'priority' => 120,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'free_gifts_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Free gifts', 'studiare-plus' ),
		'priority' => 130,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'estimate_delivery_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Estimate delivery', 'studiare-plus' ),
		'priority' => 150,
		'icon'     => 'xts-i-cart',
	)
);

Options::add_section(
	array(
		'id'       => 'abandoned_cart_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Abandoned cart', 'studiare-plus' ),
		'priority' => 160,
		'icon'     => 'xts-i-cart',
		'class'    => 'xts-preset-section-disabled',
	)
);

Options::add_section(
	array(
		'id'       => 'price_tracker_section',
		'parent'   => 'general_shop_section',
		'name'     => esc_html__( 'Price tracker', 'studiare-plus' ),
		'priority' => 170,
		'icon'     => 'xts-i-cart',
		'class'    => 'xts-preset-section-disabled',
	)
);

/**
 * Product archive.
 */
Options::add_section(
	array(
		'id'       => 'general_product_archive_section',
		'name'     => esc_html__( 'Product archive', 'studiare-plus' ),
		'priority' => 100,
		'icon'     => 'xts-i-archive',
	)
);

Options::add_section(
	array(
		'id'       => 'product_archive_section',
		'parent'   => 'general_product_archive_section',
		'name'     => esc_html__( 'Product archive', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-archive',
	)
);

Options::add_section(
	array(
		'id'       => 'products_grid_section',
		'parent'   => 'general_product_archive_section',
		'name'     => esc_html__( 'Products grid', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-archive',
	)
);

Options::add_section(
	array(
		'id'       => 'products_styles_section',
		'parent'   => 'general_product_archive_section',
		'name'     => esc_html__( 'Products styles', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-archive',
	)
);

Options::add_section(
	array(
		'id'       => 'categories_styles_section',
		'parent'   => 'general_product_archive_section',
		'name'     => esc_html__( 'Categories styles', 'studiare-plus' ),
		'priority' => 40,
		'icon'     => 'xts-i-archive',
	)
);

Options::add_section(
	array(
		'id'       => 'shop_filters_section',
		'parent'   => 'general_product_archive_section',
		'name'     => esc_html__( 'Shop filters', 'studiare-plus' ),
		'priority' => 50,
		'icon'     => 'xts-i-archive',
	)
);

Options::add_section(
	array(
		'id'       => 'widgets_section',
		'parent'   => 'general_product_archive_section',
		'name'     => esc_html__( 'Widgets', 'studiare-plus' ),
		'priority' => 60,
		'icon'     => 'xts-i-archive',
	)
);

Options::add_section(
	array(
		'id'       => 'shop_page_title_section',
		'parent'   => 'general_product_archive_section',
		'name'     => esc_html__( 'Page title', 'studiare-plus' ),
		'priority' => 70,
		'icon'     => 'xts-i-archive',
	)
);

Options::add_section(
	array(
		'id'       => 'shop_sidebar_section',
		'parent'   => 'general_product_archive_section',
		'name'     => esc_html__( 'Sidebar', 'studiare-plus' ),
		'priority' => 80,
		'icon'     => 'xts-i-archive',
	)
);

/**
 * Single product.
 */
Options::add_section(
	array(
		'id'       => 'general_single_product_section',
		'name'     => esc_html__( 'Single product', 'studiare-plus' ),
		'priority' => 110,
		'icon'     => 'xts-i-bag',
	)
);

Options::add_section(
	array(
		'id'       => 'single_product_section',
		'parent'   => 'general_single_product_section',
		'name'     => esc_html__( 'Single product', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-bag',
	)
);

Options::add_section(
	array(
		'id'       => 'product_images',
		'parent'   => 'general_single_product_section',
		'name'     => esc_html__( 'Gallery', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-bag',
	)
);

Options::add_section(
	array(
		'id'       => 'single_product_add_to_cart_section',
		'parent'   => 'general_single_product_section',
		'name'     => esc_html__( 'Add to cart', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-bag',
	)
);

Options::add_section(
	array(
		'id'       => 'product_elements',
		'parent'   => 'general_single_product_section',
		'name'     => esc_html__( 'Elements', 'studiare-plus' ),
		'priority' => 40,
		'icon'     => 'xts-i-bag',
	)
);

Options::add_section(
	array(
		'id'       => 'product_tabs',
		'parent'   => 'general_single_product_section',
		'name'     => esc_html__( 'Tabs', 'studiare-plus' ),
		'priority' => 60,
		'icon'     => 'xts-i-bag',
	)
);

Options::add_section(
	array(
		'id'       => 'single_product_related_section',
		'parent'   => 'general_single_product_section',
		'name'     => esc_html__( 'Related & Upsells', 'studiare-plus' ),
		'priority' => 70,
		'icon'     => 'xts-i-bag',
	)
);

/**
 * Login/register section.
 */
Options::add_section(
	array(
		'id'       => 'my_account',
		'name'     => esc_html__( 'My account', 'studiare-plus' ),
		'priority' => 115,
		'icon'     => 'xts-i-login',
	)
);

Options::add_section(
	array(
		'id'       => 'login_section',
		'parent'   => 'my_account',
		'name'     => esc_html__( 'Login / Register', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-login',
	)
);

Options::add_section(
	array(
		'id'       => 'dashboard_section',
		'parent'   => 'my_account',
		'name'     => esc_html__( 'Dashboard', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-login',
	)
);

/**
 * Share buttons configuration.
 */
Options::add_section(
	array(
		'id'       => 'general_social_profiles',
		'name'     => esc_html__( 'Social profiles', 'studiare-plus' ),
		'priority' => 130,
		'icon'     => 'xts-i-social',
	)
);

Options::add_section(
	array(
		'id'       => 'social_profiles',
		'parent'   => 'general_social_profiles',
		'name'     => esc_html__( 'Social profiles', 'studiare-plus' ),
		'priority' => 10,
		'icon'     => 'xts-i-social',
	)
);

Options::add_section(
	array(
		'id'       => 'social_links',
		'parent'   => 'general_social_profiles',
		'name'     => esc_html__( 'Links to social profiles', 'studiare-plus' ),
		'priority' => 20,
		'icon'     => 'xts-i-social',
	)
);

Options::add_section(
	array(
		'id'       => 'social_share',
		'parent'   => 'general_social_profiles',
		'name'     => esc_html__( 'Share buttons', 'studiare-plus' ),
		'priority' => 30,
		'icon'     => 'xts-i-social',
	)
);

/**
 * API integrations.
 */
Options::add_section(
	array(
		'id'       => 'api_integrations_section',
		'name'     => esc_html__( 'API integrations', 'studiare-plus' ),
		'priority' => 140,
		'icon'     => 'xts-i-cog',
	)
);

Options::add_section(
	array(
		'id'       => 'instagram_api_section',
		'name'     => esc_html__( 'Instagram API', 'studiare-plus' ),
		'parent'   => 'api_integrations_section',
		'priority' => 10,
		'icon'     => 'xts-i-cog',
	)
);

Options::add_section(
	array(
		'id'       => 'google_api_section',
		'name'     => esc_html__( 'Google map API', 'studiare-plus' ),
		'parent'   => 'api_integrations_section',
		'priority' => 20,
		'icon'     => 'xts-i-cog',
	)
);

Options::add_section(
	array(
		'id'       => 'social_login_api_section',
		'name'     => esc_html__( 'Social authentication', 'studiare-plus' ),
		'parent'   => 'api_integrations_section',
		'priority' => 30,
		'icon'     => 'xts-i-cog',
	)
);

/**
 * Performance.
 */
Options::add_section(
	array(
		'id'       => 'general_performance',
		'name'     => esc_html__( 'Performance', 'studiare-plus' ),
		'priority' => 150,
		'icon'     => 'xts-i-performance',
	)
);

Options::add_section(
	array(
		'id'       => 'performance_css',
		'name'     => esc_html__( 'CSS', 'studiare-plus' ),
		'parent'   => 'general_performance',
		'priority' => 10,
		'icon'     => 'xts-i-performance',
	)
);

Options::add_section(
	array(
		'id'       => 'performance_js',
		'name'     => esc_html__( 'JS', 'studiare-plus' ),
		'parent'   => 'general_performance',
		'priority' => 20,
		'icon'     => 'xts-i-performance',
	)
);

Options::add_section(
	array(
		'id'       => 'fonts_section',
		'name'     => esc_html__( 'Fonts & Icons', 'studiare-plus' ),
		'parent'   => 'general_performance',
		'priority' => 30,
		'icon'     => 'xts-i-performance',
	)
);

Options::add_section(
	array(
		'id'       => 'performance_lazy_loading',
		'name'     => esc_html__( 'Lazy loading', 'studiare-plus' ),
		'parent'   => 'general_performance',
		'priority' => 40,
		'icon'     => 'xts-i-performance',
	)
);

Options::add_section(
	array(
		'id'       => 'plugins_section',
		'name'     => esc_html__( 'Plugins', 'studiare-plus' ),
		'parent'   => 'general_performance',
		'priority' => 50,
		'icon'     => 'xts-i-performance',
	)
);

Options::add_section(
	array(
		'id'       => 'preloader_section',
		'name'     => esc_html__( 'Preloader', 'studiare-plus' ),
		'parent'   => 'general_performance',
		'priority' => 60,
		'icon'     => 'xts-i-performance',
	)
);

Options::add_section(
	array(
		'id'       => 'lcp_section',
		'name'     => esc_html__( 'LCP', 'studiare-plus' ),
		'parent'   => 'general_performance',
		'priority' => 70,
		'icon'     => 'xts-i-performance',
	)
);

Options::add_section(
	array(
		'id'       => 'performance_other',
		'name'     => esc_html__( 'Other', 'studiare-plus' ),
		'parent'   => 'general_performance',
		'priority' => 80,
		'icon'     => 'xts-i-performance',
	)
);

/**
 * Maintenance.
 */
Options::add_section(
	array(
		'id'       => 'maintenance',
		'name'     => esc_html__( 'Maintenance', 'studiare-plus' ),
		'priority' => 160,
		'icon'     => 'xts-i-tools',
		'class'    => 'xts-preset-section-disabled',
	)
);


/**
 * Custom CSS section.
 */
Options::add_section(
	array(
		'id'       => 'custom_css',
		'name'     => esc_html__( 'Custom CSS', 'studiare-plus' ),
		'priority' => 180,
		'icon'     => 'xts-i-file-code-css',
	)
);

/**
 * Custom JS section.
 */
Options::add_section(
	array(
		'id'       => 'custom_js',
		'name'     => esc_html__( 'Custom JS', 'studiare-plus' ),
		'priority' => 190,
		'icon'     => 'xts-i-file-code-js',
	)
);

/**
 * Other.
 */
Options::add_section(
	array(
		'id'       => 'other_section',
		'name'     => esc_html__( 'Other', 'studiare-plus' ),
		'priority' => 200,
		'icon'     => 'xts-i-setting-slider-in-square',
	)
);

/**
 * Import / Export / Reset.
 */
Options::add_section(
	array(
		'id'       => 'import_export',
		'name'     => esc_html__( 'Import / Export / Reset', 'studiare-plus' ),
		'priority' => 220,
		'icon'     => 'xts-i-round-right',
		'class'    => 'xts-preset-section-disabled',
	)
);
