<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

use XTS\Admin\Modules\Options;

Options::add_field(
	array(
		'id'          => 'mobile_optimization',
		'name'        => esc_html__( 'Mobile DOM optimization (experimental)', 'studiare-plus' ),
		'description' => esc_html__( 'You can reduce the number of DOM elements on mobile devices. This option currently removes all HTML tags from the desktop header version on mobile devices.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_other',
		'default'     => false,
		'priority'    => 10,
	)
);

Options::add_field(
	array(
		'id'          => 'load_text_domain',
		'name'        => esc_html__( 'Load text domain', 'studiare-plus' ),
		'description' => esc_html__( 'Enable it to load translations from all possible locations. Usually needs to be disabled so the translation will be loaded from the system folder only wp-content/languages/themes and the performance will be better.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_other',
		'default'     => true,
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'priority'    => 20,
	)
);

/**
 * CSS.
 */
Options::add_field(
	array(
		'id'          => 'disable_gutenberg_css',
		'name'        => esc_html__( 'Disable default Gutenberg blocks styles', 'studiare-plus' ),
		'description' => esc_html__( 'If you are not using default Gutenberg blocks you will not need these files to be loaded.', 'studiare-plus' ),
		'group'       => esc_html__( 'General', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_css',
		'default'     => false,
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'priority'    => 40,
		'class'       => 'xts-col-6',
	)
);

Options::add_field(
	array(
		'id'          => 'inline_critical_css',
		'name'        => esc_html__( 'Convert large CSS files to inline styles', 'studiare-plus' ),
		'description' => esc_html__( 'Inline the stylesheet into the HTML to avoid the additional network request (reduce or inline render-blocking stylesheets).', 'studiare-plus' ),
		'group'       => esc_html__( 'General', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_css',
		'default'     => false,
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'priority'    => 50,
		'class'       => 'xts-col-6',
	)
);

Options::add_field(
	array(
		'id'       => 'advanced_css_notice',
		'type'     => 'notice',
		'style'    => 'info',
		'name'     => '',
		'group'    => esc_html__( 'Advanced', 'studiare-plus' ),
		'content'  => wp_kses(
			__( 'Our theme is designed to load only the styles required for each specific page. However, if you need to globally load or remove certain CSS files for any reason, you can use the following set of options.', 'studiare-plus' ),
			array(
				'a'      => array(
					'href'   => true,
					'target' => true,
				),
				'br'     => array(),
				'strong' => array(),
				'u'      => array(),
			)
		),
		'section'  => 'performance_css',
		'priority' => 59,
	)
);

Options::add_field(
	array(
		'id'          => 'styles_always_use',
		'name'        => esc_html__( 'Styles always load', 'studiare-plus' ),
		'description' => esc_html__( 'You can manually load some styles on all pages.', 'studiare-plus' ),
		'group'       => esc_html__( 'Advanced', 'studiare-plus' ),
		'section'     => 'performance_css',
		'type'        => 'select',
		'multiple'    => true,
		'select2'     => true,
		'buttons'     => 'disable',
		'options'     => '',
		'callback'    => 'woodmart_get_theme_settings_css_files_array',
		'default'     => array(),
		'priority'    => 60,
	)
);

Options::add_field(
	array(
		'id'          => 'styles_not_use',
		'name'        => esc_html__( 'Styles never load', 'studiare-plus' ),
		'description' => esc_html__( 'You can manually unload some styles on all pages.', 'studiare-plus' ),
		'group'       => esc_html__( 'Advanced', 'studiare-plus' ),
		'section'     => 'performance_css',
		'type'        => 'select',
		'multiple'    => true,
		'select2'     => true,
		'buttons'     => 'disable',
		'options'     => '',
		'callback'    => 'woodmart_get_theme_settings_css_files_name_array',
		'default'     => array(),
		'priority'    => 70,
	)
);

/**
 * JS
 */
Options::add_field(
	array(
		'id'          => 'disable_owl_mobile_devices',
		'name'        => esc_html__( 'Disable Swiper slider script on mobile devices', 'studiare-plus' ),
		'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'disable-owl-carousel.mp4" autoplay loop muted></video>',
		'description' => esc_html__( 'Using native browser scrolling feature on mobile devices may improve your page loading and performance on some devices. This option does not apply to the main product carousel and WoodMart slider.', 'studiare-plus' ),
		'group'       => esc_html__( 'General', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_js',
		'default'     => false,
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'priority'    => 40,
		'class'       => 'xts-col-6',
	)
);

Options::add_field(
	array(
		'id'          => 'remove_jquery_migrate',
		'name'        => esc_html__( 'Remove jQuery Migrate', 'studiare-plus' ),
		'description' => esc_html__( 'Remove jQuery Migrate eliminates a JS file and can improve load time.', 'studiare-plus' ),
		'group'       => esc_html__( 'General', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_js',
		'default'     => false,
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'priority'    => 45,
		'class'    => 'xts-col-6',
	)
);

Options::add_field(
	array(
		'id'       => 'advanced_js_notice',
		'type'     => 'notice',
		'style'    => 'info',
		'name'     => '',
		'group'    => esc_html__( 'Advanced', 'studiare-plus' ),
		'content'  => wp_kses(
			__( 'Our theme is designed to load only the scripts and libraries required for each specific page. However, if you need to load a particular script globally for any reason, you can use the following options.', 'studiare-plus' ),
			array(
				'a'      => array(
					'href'   => true,
					'target' => true,
				),
				'br'     => array(),
				'strong' => array(),
				'u'      => array(),
			)
		),
		'section'  => 'performance_js',
		'priority' => 49,
	)
);

Options::add_field(
	array(
		'id'          => 'advanced_js',
		'name'        => esc_html__( 'Advanced scripts controls', 'studiare-plus' ),
		'group'       => esc_html__( 'Advanced', 'studiare-plus' ),
		'description' => esc_html__( 'This option doesn\'t affect anything. It just shows/hides all scripts configuration. Note that we don\'t recommend you enable/disable any scripts if you are not sure how they work.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_js',
		'default'     => false,
		'priority'    => 50,
	)
);

$config_libraries = woodmart_get_config( 'js-libraries' );
foreach ( $config_libraries as $key => $libraries ) {
	foreach ( $libraries as $library ) {
		Options::add_field(
			array(
				'id'       => $library['name'] . '_library',
				'section'  => 'performance_js',
				'name'     => ucfirst( $library['title'] ) . ' ' . esc_html__( 'library', 'studiare-plus' ),
				'group'    => esc_html__( 'Advanced', 'studiare-plus' ),
				'type'     => 'buttons',
				'options'  => array(
					'always'   => array(
						'name'  => esc_html__( 'Always load', 'studiare-plus' ),
						'value' => 'always',
					),
					'required' => array(
						'name'  => esc_html__( 'On demand', 'studiare-plus' ),
						'value' => 'required',
					),
					'not_use'  => array(
						'name'  => esc_html__( 'Never load', 'studiare-plus' ),
						'value' => 'not_use',
					),
				),
				'requires' => array(
					array(
						'key'     => 'advanced_js',
						'compare' => 'equals',
						'value'   => true,
					),
				),
				'default'  => isset( $library['default'] ) ? $library['default'] : 'required',
				'priority' => 60,
				'class'    => 'xts-col-6',
			)
		);
	}
}

Options::add_field(
	array(
		'id'          => 'scripts_always_use',
		'name'        => esc_html__( 'Scripts always load', 'studiare-plus' ),
		'description' => esc_html__( 'You can manually load some initialization scripts on all pages.', 'studiare-plus' ),
		'group'       => esc_html__( 'Advanced', 'studiare-plus' ),
		'section'     => 'performance_js',
		'type'        => 'select',
		'multiple'    => true,
		'select2'     => true,
		'buttons'     => 'disable',
		'options'     => '',
		'callback'    => 'woodmart_get_theme_settings_js_scripts_files_array',
		'default'     => array(),
		'requires'    => array(
			array(
				'key'     => 'advanced_js',
				'compare' => 'equals',
				'value'   => true,
			),
		),
		'priority'    => 70,
	)
);

Options::add_field(
	array(
		'id'          => 'scripts_not_use',
		'name'        => esc_html__( 'Scripts never load', 'studiare-plus' ),
		'description' => esc_html__( 'You can manually unload some initialization scripts on all pages.', 'studiare-plus' ),
		'group'       => esc_html__( 'Advanced', 'studiare-plus' ),
		'section'     => 'performance_js',
		'type'        => 'select',
		'multiple'    => true,
		'select2'     => true,
		'buttons'     => 'disable',
		'options'     => '',
		'callback'    => 'woodmart_get_theme_settings_js_scripts_files_array',
		'default'     => array(),
		'requires'    => array(
			array(
				'key'     => 'advanced_js',
				'compare' => 'equals',
				'value'   => true,
			),
		),
		'priority'    => 80,
	)
);

Options::add_field(
	array(
		'id'          => 'dequeue_scripts',
		'type'        => 'text_input',
		'section'     => 'performance_js',
		'name'        => esc_html__( 'Dequeue scripts', 'studiare-plus' ),
		'description' => esc_html__( 'You can manually disable JS files from being loaded using their keys. Write their case separated with a comma. For example: woodmart-theme,elementor-frontend', 'studiare-plus' ),
		'group'       => esc_html__( 'Advanced', 'studiare-plus' ),
		'requires'    => array(
			array(
				'key'     => 'advanced_js',
				'compare' => 'equals',
				'value'   => true,
			),
		),
		'status'      => 'deprecated',
		'priority'    => 90,
	)
);

/**
 * Lazy loading
 */
Options::add_field(
	array(
		'id'          => 'lazy_loading',
		'name'        => esc_html__( 'Lazy loading for images', 'studiare-plus' ),
		'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'lazy-loading-for-images.mp4" autoplay loop muted></video>',
		'description' => esc_html__( 'Enable this option to optimize your images loading on the website. They will be loaded only when user will scroll the page.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_lazy_loading',
		'default'     => false,
		'priority'    => 10,
	)
);

Options::add_field(
	array(
		'id'          => 'lazy_loading_bg_images',
		'name'        => esc_html__( 'Lazy loading for background images', 'studiare-plus' ),
		'description' => esc_html__( 'Enables lazy loading for background images in Gutenberg blocks, improving performance by loading images only when they enter the viewport.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_lazy_loading',
		'default'     => false,
		'priority'    => 15,
	)
);

Options::add_field(
	array(
		'id'          => 'lazy_loading_offset',
		'name'        => esc_html__( 'Offset', 'studiare-plus' ),
		'description' => esc_html__( 'Start load images X pixels before the page is scrolled to the item', 'studiare-plus' ),
		'type'        => 'range',
		'section'     => 'performance_lazy_loading',
		'default'     => 0,
		'min'         => 0,
		'step'        => 10,
		'max'         => 1000,
		'priority'    => 20,
		'unit'        => 'px',
	)
);

Options::add_field(
	array(
		'id'       => 'lazy_effect',
		'name'     => esc_html__( 'Appearance effect', 'studiare-plus' ),
		'type'     => 'buttons',
		'section'  => 'performance_lazy_loading',
		'default'  => 'none',
		'options'  => array(
			'none' => array(
				'name'  => esc_html__( 'None', 'studiare-plus' ),
				'value' => 'none',
			),
			'fade' => array(
				'name'  => esc_html__( 'Fade', 'studiare-plus' ),
				'hint'  => '<video data-src="' . WOODMART_TOOLTIP_URL . 'lazy-loading-appearance-effect-fade.mp4" autoplay loop muted></video>',
				'value' => 'fade',
			),
		),
		'priority' => 30,
	)
);

Options::add_field(
	array(
		'id'          => 'lazy_custom_placeholder',
		'name'        => esc_html__( 'Upload custom placeholder image', 'studiare-plus' ),
		'description' => esc_html__( 'Add your custom image placeholder that will be used before the original image will be loaded.', 'studiare-plus' ),
		'type'        => 'upload',
		'section'     => 'performance_lazy_loading',
		'priority'    => 40,
	)
);

Options::add_field(
	array(
		'id'          => 'disable_wordpress_lazy_loading',
		'name'        => esc_html__( 'Disable native WordPress lazy loading', 'studiare-plus' ),
		'description' => esc_html__( 'This option will remove attribute loading=“lazy” from all images on your website.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'performance_lazy_loading',
		'default'     => false,
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'priority'    => 80,
	)
);

/**
 * Plugins
 */
Options::add_field(
	array(
		'id'          => 'rocket_delay_js_exclusions',
		'name'        => esc_html__( 'WP Rocket delay JS exclusions', 'studiare-plus' ),
		'description' => esc_html__( 'Add a list of JS files that don’t need to be delayed to the exclusion list for WP Rocket. It contains JS files for elements like header, mobile menu, and other elements that usually need to be active right after opening the page.', 'studiare-plus' ),
		'group'       => esc_html__( 'WP Rocket', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'plugins_section',
		'default'     => false,
		'priority'    => 15,
	)
);

Options::add_field(
	array(
		'id'          => 'cf7_js',
		'name'        => esc_html__( 'Load "Contact form 7" JS files', 'studiare-plus' ),
		'description' => esc_html__( 'You can enable/disable this option globally. If you want to load them on the particular page only, you can create a special Theme Settings preset for this and add a condition for that page.', 'studiare-plus' ),
		'group'       => esc_html__( 'Contact form 7', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'plugins_section',
		'default'     => true,
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'priority'    => 11,
	)
);

/**
 * Fonts
 */
Options::add_field(
	array(
		'id'          => 'google_font_display',
		'name'        => esc_html__( '"font-display" for text fonts', 'studiare-plus' ),
		'description' => wp_kses(
			__( 'You can specify "font-display" property for text fonts. Read more information <a href="https://developers.google.com/web/updates/2016/02/font-display">here</a>', 'studiare-plus' ),
			true
		),
		'type'        => 'select',
		'section'     => 'fonts_section',
		'default'     => 'disable',
		'options'     => array(
			'disable'  => array(
				'name'  => esc_html__( 'Disable', 'studiare-plus' ),
				'value' => 'disable',
			),
			'block'    => array(
				'name'  => esc_html__( 'Block', 'studiare-plus' ),
				'value' => 'block',
			),
			'swap'     => array(
				'name'  => esc_html__( 'Swap', 'studiare-plus' ),
				'value' => 'swap',
			),
			'fallback' => array(
				'name'  => esc_html__( 'Fallback', 'studiare-plus' ),
				'value' => 'fallback',
			),
			'optional' => array(
				'name'  => esc_html__( 'Optional', 'studiare-plus' ),
				'value' => 'optional',
			),
		),
		'priority'    => 10,
	)
);

Options::add_field(
	array(
		'id'          => 'icons_font_display',
		'name'        => esc_html__( '"font-display" for icon fonts', 'studiare-plus' ),
		'description' => wp_kses(
			__( 'You can specify "font-display" property for icon fonts used in our theme. Read more information <a href="https://developers.google.com/web/updates/2016/02/font-display">here</a>', 'studiare-plus' ),
			true
		),
		'type'        => 'select',
		'section'     => 'fonts_section',
		'default'     => 'disable',
		'options'     => array(
			'disable'  => array(
				'name'  => esc_html__( 'Disable', 'studiare-plus' ),
				'value' => 'disable',
			),
			'block'    => array(
				'name'  => esc_html__( 'Block', 'studiare-plus' ),
				'value' => 'block',
			),
			'swap'     => array(
				'name'  => esc_html__( 'Swap', 'studiare-plus' ),
				'value' => 'swap',
			),
			'fallback' => array(
				'name'  => esc_html__( 'Fallback', 'studiare-plus' ),
				'value' => 'fallback',
			),
		),
		'priority'    => 20,
	)
);

Options::add_field(
	array(
		'id'          => 'font_awesome_css',
		'name'        => esc_html__( 'Font Awesome library', 'studiare-plus' ),
		'description' => esc_html__( 'You can force Font Awesome library to be loaded on all pages. This option works only if Elementor or WPBakery is active.', 'studiare-plus' ),
		'type'        => 'buttons',
		'section'     => 'fonts_section',
		'options'     => array(
			'always'  => array(
				'name'  => esc_html__( 'Always use', 'studiare-plus' ),
				'value' => 'always',
			),
			'not_use' => array(
				'name'  => esc_html__( 'Don\'t use', 'studiare-plus' ),
				'value' => 'not_use',
			),
		),
		'default'     => 'not_use',
		'priority'    => 30,
		'status'      => 'deprecated',
		'status_description' => esc_html__( 'Since from Elementor version 3.18.0 "Inline Font Icons" feature is enabled by default, the Font Awesome icon font can’t be added to site pages using this option.', 'studiare-plus' ),
	)
);

Options::add_field(
	array(
		'id'          => 'font_icon_woff2_preload',
		'name'        => esc_html__( 'Preload key request for "woodmart-font.woff2"', 'studiare-plus' ),
		'description' => esc_html__( 'Enable this option if you see this warning in Google Pagespeed report.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'fonts_section',
		'default'     => false,
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'priority'    => 50,
	)
);

/**
 * Preloader
 */
Options::add_field(
	array(
		'id'          => 'preloader',
		'name'        => esc_html__( 'Preloader', 'studiare-plus' ),
		'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'preloader.mp4" autoplay loop muted></video>',
		'description' => esc_html__( 'Enable preloader animation while loading your website content. Useful when you move all the CSS to the footer.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'preloader_section',
		'default'     => false,
		'priority'    => 10,
	)
);

Options::add_field(
	array(
		'id'          => 'preloader_image',
		'name'        => esc_html__( 'Custom animated loader', 'studiare-plus' ),
		'description' => esc_html__( 'Upload a custom animated image that will replace the default theme preloader.', 'studiare-plus' ),
		'type'        => 'upload',
		'section'     => 'preloader_section',
		'priority'    => 20,
	)
);

Options::add_field(
	array(
		'id'       => 'preloader_background_color',
		'name'     => esc_html__( 'Background for loader screen', 'studiare-plus' ),
		'group'    => esc_html__( 'Style', 'studiare-plus' ),
		'type'     => 'color',
		'default'  => array(
			'idle' => '#ffffff',
		),
		'section'  => 'preloader_section',
		'priority' => 30,
	)
);


Options::add_field(
	array(
		'id'       => 'preloader_color_scheme',
		'name'     => esc_html__( 'Preloader color scheme', 'studiare-plus' ),
		'group'    => esc_html__( 'Style', 'studiare-plus' ),
		'type'     => 'buttons',
		'section'  => 'preloader_section',
		'default'  => 'dark',
		'options'  => array(
			'dark'  => array(
				'name'  => esc_html__( 'Dark', 'studiare-plus' ),
				'value' => 'dark',
			),
			'light' => array(
				'name'  => esc_html__( 'Light', 'studiare-plus' ),
				'value' => 'light',
			),
		),
		'priority' => 40,
	)
);

Options::add_field(
	array(
		'id'          => 'preload_lcp_image',
		'name'        => esc_html__( 'Preload LCP Image', 'studiare-plus' ),
		'description' => esc_html__( 'Adds priority loading for the Largest Contentful Paint (LCP) image. The image is set in the meta boxes of each page to speed up the display of the main content.', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'lcp_section',
		'default'     => false,
		'priority'    => 10,
	)
);
