<?php
if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}

use XTS\Admin\Modules\Options;

Options::add_field(
	array(
		'id'          => 'page-title-design',
		'name'        => esc_html__( 'Page title design', 'studiare-plus' ),
		'description' => esc_html__( 'Select page title section design or disable it completely on all pages.', 'studiare-plus' ),
		'group'       => esc_html__( 'Style', 'studiare-plus' ),
		'type'        => 'buttons',
		'section'     => 'page_title_section',
		'options'     => array(
			'default'  => array(
				'name'  => esc_html__( 'Default', 'studiare-plus' ),
				'value' => 'default',
				'image' => WOODMART_ASSETS_IMAGES . '/settings/page-heading/default.jpg',
			),
			'centered' => array(
				'name'  => esc_html__( 'Centered', 'studiare-plus' ),
				'value' => 'centered',
				'image' => WOODMART_ASSETS_IMAGES . '/settings/page-heading/centered.jpg',
			),
			'disable'  => array(
				'name'  => esc_html__( 'Disable', 'studiare-plus' ),
				'value' => 'disable',
				'image' => WOODMART_ASSETS_IMAGES . '/settings/page-heading/disable.jpg',
			),
		),
		'default'     => 'disable',
		'tags'        => 'page heading title design',
		'priority'    => 10,
	)
);

Options::add_field(
	array(
		'id'          => 'page-title-size',
		'name'        => esc_html__( 'Page title size', 'studiare-plus' ),
		'description' => esc_html__( 'You can set different sizes for your page titles.', 'studiare-plus' ),
		'group'       => esc_html__( 'Style', 'studiare-plus' ),
		'type'        => 'buttons',
		'section'     => 'page_title_section',
		'options'     => array(
			'default' => array(
				'name'  => esc_html__( 'Default', 'studiare-plus' ),
				'hint'  => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'page-title-size-default.jpg" alt="">', true ),
				'value' => 'default',
			),
			'small'   => array(
				'name'  => esc_html__( 'Small', 'studiare-plus' ),
				'hint'  => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'page-title-size-small.jpg" alt="">', true ),
				'value' => 'small',
			),
			'large'   => array(
				'name'  => esc_html__( 'Large', 'studiare-plus' ),
				'hint'  => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'page-title-size-large.jpg" alt="">', true ),
				'value' => 'large',
			),
		),
		'default'     => 'default',
		'tags'        => 'page heading title size breadcrumbs size',
		'priority'    => 20,
	)
);

Options::add_field(
	array(
		'id'          => 'title-background',
		'name'        => esc_html__( 'Pages title background', 'studiare-plus' ),
		'description' => esc_html__( 'Set background image or color, that will be used as a default for all page titles, shop page and blog.', 'studiare-plus' ),
		'group'       => esc_html__( 'Style', 'studiare-plus' ),
		'type'        => 'background',
		'default'     => array(
			'color'    => '#0a0a0a',
			'position' => 'center center',
			'size'     => 'cover',
		),
		'options'     => ! apply_filters( 'woodmart_generate_legacy_page_title_bg', false ) ? array(
			'repeat'     => false,
			'attachment' => false,
			'size'       => array(
				''        => '',
				'cover'   => esc_html__( 'Cover', 'studiare-plus' ),
				'contain' => esc_html__( 'Contain', 'studiare-plus' ),
				'fill'    => esc_html__( 'Fill', 'studiare-plus' ),
				'none'    => esc_html__( 'None', 'studiare-plus' ),
			),
		) : array(),
		'allowed'     => ! apply_filters( 'woodmart_generate_legacy_page_title_bg', false ) ? array(
			'repeat'     => false,
			'attachment' => false,
		) : array(),
		'css_rules'   => ! apply_filters( 'woodmart_generate_legacy_page_title_bg', false ) ? array(
			'color'    => false,
			'image'    => false,
			'size'     => 'object-fit',
			'position' => 'object-position',
		) : array(),
		'section'     => 'page_title_section',
		'selector'    => apply_filters( 'woodmart_generate_legacy_page_title_bg', false ) ? '.wd-page-title' : '.wd-page-title .wd-page-title-bg img',
		'tags'        => 'page title color page title background',
		'priority'    => 30,
	)
);

Options::add_field(
	array(
		'id'          => 'page-title-color',
		'name'        => esc_html__( 'Text color for page title', 'studiare-plus' ),
		'description' => esc_html__( 'You can set text different color depending on its background. It can be light or dark.', 'studiare-plus' ),
		'group'       => esc_html__( 'Style', 'studiare-plus' ),
		'type'        => 'buttons',
		'section'     => 'page_title_section',
		'options'     => array(
			'default' => array(
				'name'  => esc_html__( 'Default', 'studiare-plus' ),
				'value' => 'default',
			),
			'light'   => array(
				'name'  => esc_html__( 'Light', 'studiare-plus' ),
				'value' => 'light',
			),
			'dark'    => array(
				'name'  => esc_html__( 'Dark', 'studiare-plus' ),
				'value' => 'dark',
			),
		),
		'default'     => 'light',
		'priority'    => 50,
	)
);

Options::add_field(
	array(
		'id'          => 'page_title_tag',
		'name'        => esc_html__( 'Title tag', 'studiare-plus' ),
		'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'page-title-title-tag.jpg" alt="">', true ),
		'description' => esc_html__( 'Choose which HTML tag to use for the page title.', 'studiare-plus' ),
		'group'       => esc_html__( 'SEO', 'studiare-plus' ),
		'type'        => 'select',
		'section'     => 'page_title_section',
		'default'     => 'default',
		'options'     => array(
			'default' => array(
				'name'  => esc_html__( 'Default', 'studiare-plus' ),
				'value' => 'default',
			),
			'h1'      => array(
				'name'  => 'h1',
				'value' => 'h1',
			),
			'h2'      => array(
				'name'  => 'h2',
				'value' => 'h2',
			),
			'h3'      => array(
				'name'  => 'h3',
				'value' => 'h3',
			),
			'h4'      => array(
				'name'  => 'h4',
				'value' => 'h4',
			),
			'h5'      => array(
				'name'  => 'h5',
				'value' => 'h5',
			),
			'h6'      => array(
				'name'  => 'h6',
				'value' => 'h6',
			),
			'p'       => array(
				'name'  => 'p',
				'value' => 'p',
			),
			'div'     => array(
				'name'  => 'div',
				'value' => 'div',
			),
			'span'    => array(
				'name'  => 'span',
				'value' => 'span',
			),
		),
		'priority'    => 55,
	)
);

Options::add_field(
	array(
		'id'          => 'breadcrumbs',
		'section'     => 'page_title_section',
		'name'        => esc_html__( 'Show breadcrumbs', 'studiare-plus' ),
		'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'page-title-show-breadcrumbs.jpg" alt="">', true ),
		'description' => esc_html__( 'Displays a full chain of links to the current page.', 'studiare-plus' ),
		'group'       => esc_html__( 'SEO', 'studiare-plus' ),
		'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
		'off-text'    => esc_html__( 'No', 'studiare-plus' ),
		'type'        => 'switcher',
		'default'     => '1',
		'priority'    => 60,
	)
);

Options::add_field(
	array(
		'id'          => 'yoast_shop_breadcrumbs',
		'section'     => 'page_title_section',
		'name'        => esc_html__( 'Yoast breadcrumbs for shop', 'studiare-plus' ),
		'description' => esc_html__( 'Requires Yoast SEO plugin to be installed. Replaces standard WooCommerce breadcrumbs with the custom one that comes with the plugin. You need to enable and configure it in Dashboard -> SEO -> Search Appearance -> Breadcrumbs.', 'studiare-plus' ),
		'group'       => esc_html__( 'SEO', 'studiare-plus' ),
		'type'        => 'switcher',
		'default'     => false,
		'priority'    => 70,
	)
);

Options::add_field(
	array(
		'id'          => 'yoast_pages_breadcrumbs',
		'section'     => 'page_title_section',
		'name'        => esc_html__( 'Yoast breadcrumbs for pages', 'studiare-plus' ),
		'description' => esc_html__( 'Requires Yoast SEO plugin to be installed. Replaces standard breadcrumbs with the custom one that comes with the plugin. You need to enable and configure it in Dashboard -> SEO -> Search Appearance -> Breadcrumbs.', 'studiare-plus' ),
		'group'       => esc_html__( 'SEO', 'studiare-plus' ),
		'type'        => 'switcher',
		'default'     => false,
		'priority'    => 80,
	)
);
