<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}
use XTS\Admin\Modules\Options;

Options::add_field(
	array(
		'id'          => 'login_tabs',
		'name'        => esc_html__( 'Login page tabs', 'studiare-plus' ),
		'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'login-page-tabs.mp4" autoplay loop muted></video>',
		'description' => esc_html__( 'Enable tabs for login and register forms', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'login_section',
		'default'     => '0',
		'priority'    => 10,
	)
);

Options::add_field(
	array(
		'id'       => 'reg_title',
		'name'     => esc_html__( 'Registration title', 'studiare-plus' ),
		'group'    => esc_html__( 'Registrer', 'studiare-plus' ),
		'type'     => 'text_input',
		'section'  => 'login_section',
		'default'  => 'عضویت',
		'priority' => 20,
	)
);

Options::add_field(
	array(
		'id'          => 'reg_text',
		'name'        => esc_html__( 'Registration text', 'studiare-plus' ),
		'description' => esc_html__( 'Show some information about registration on your web-site', 'studiare-plus' ),
		'group'    => esc_html__( 'Registrer', 'studiare-plus' ),
		'type'        => 'textarea',
		'wysiwyg'     => true,
		'section'     => 'login_section',
		'default'     => 'ثبت نام در این سایت به شما امکان دسترسی به وضعیت و تاریخچه سفارش خود را می‌دهد. فقط فیلدهای زیر را پر کنید و ما در کمترین زمان یک حساب کاربری جدید برای شما ایجاد خواهیم کرد. ما فقط اطلاعات لازم را از شما خواهیم خواست تا فرآیند خرید را سریع‌تر و آسان‌تر کنیم.',
		'priority'    => 30,
	)
);


Options::add_field(
	array(
		'id'       => 'login_title',
		'name'     => esc_html__( 'Login title', 'studiare-plus' ),
		'group'    => esc_html__( 'Login', 'studiare-plus' ),
		'type'     => 'text_input',
		'section'  => 'login_section',
		'default'  => 'ورود به حساب',
		'priority' => 40,
	)
);

Options::add_field(
	array(
		'id'          => 'login_text',
		'name'        => esc_html__( 'Login text', 'studiare-plus' ),
		'description' => esc_html__( 'Show some information about login on your web-site', 'studiare-plus' ),
		'group'    => esc_html__( 'Login', 'studiare-plus' ),
		'type'        => 'textarea',
		'wysiwyg'     => true,
		'section'     => 'login_section',
		'default'     => '',
		'priority'    => 50,
	)
);


Options::add_field(
	array(
		'id'          => 'notifications_on',
		'name'        => esc_html__( 'اعلانات', 'studiare-plus' ),
		'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'portfolio.jpg" alt="">', true ),
		'description' => esc_html__( 'فعال و غیر فعال کردن بخش اعلانات در حساب کاربری', 'studiare-plus' ),
		'type'        => 'switcher',
		'section'     => 'dashboard_section',
		'default'     => '1',
		'priority'    => 10,
	)
);
