<?php
if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}

use XTS\Admin\Modules\Options;

Options::add_field(
	array(
		'id'          => 'site_width',
		'name'        => esc_html__( 'Site width', 'studiare-plus' ),
		'description' => esc_html__( 'You can make your content wrapper boxed, full width or set your custom width in pixels.', 'studiare-plus' ),
		'type'        => 'select',
		'section'     => 'general_layout_section',
		'options'     => array(
			'full-width'         => array(
				'name'  => esc_html__( 'Full width', 'studiare-plus' ),
				'value' => 'full-width',
			),
			'boxed'              => array(
				'name'  => esc_html__( 'Boxed (with hidden overflow)', 'studiare-plus' ),
				'value' => 'boxed',
			),
			'boxed-2'            => array(
				'name'  => esc_html__( 'Boxed', 'studiare-plus' ),
				'value' => 'boxed-2',
			),
			'full-width-content' => array(
				'name'  => esc_html__( 'Content full width', 'studiare-plus' ),
				'value' => 'full-width-content',
			),
			'wide'               => array(
				'name'  => esc_html__( 'Wide (1600 px)', 'studiare-plus' ),
				'value' => 'wide',
			),
			'custom'             => array(
				'name'  => esc_html__( 'Custom', 'studiare-plus' ),
				'value' => 'custom',
			),
		),
		'default'     => 'custom',
		'tags'        => 'boxed full width wide',
		'priority'    => 20,
	)
);

Options::add_field(
	array(
		'id'          => 'site_custom_width',
		'name'        => esc_html__( 'Custom width in pixels', 'studiare-plus' ),
		'description' => esc_html__( 'Specify your custom website container width in pixels.', 'studiare-plus' ),
		'type'        => 'range',
		'section'     => 'general_layout_section',
		'default'     => 1340,
		'min'         => 1025,
		'max'         => 1920,
		'step'        => 1,
		'priority'    => 30,
		'requires'    => array(
			array(
				'key'     => 'site_width',
				'compare' => 'equals',
				'value'   => 'custom',
			),
		),
		'unit'        => 'px',
	)
);

Options::add_field(
	array(
		'id'          => 'main_layout',
		'name'        => esc_html__( 'Sidebar position', 'studiare-plus' ),
		'description' => esc_html__( 'Select main content and sidebar alignment.', 'studiare-plus' ),
		'group'       => esc_html__( 'Sidebar', 'studiare-plus' ),
		'type'        => 'buttons',
		'section'     => 'general_layout_section',
		'options'     => array(
			'full-width'    => array(
				'name'  => esc_html__( 'Without', 'studiare-plus' ),
				'value' => 'full-width',
				'image' => WOODMART_ASSETS_IMAGES . '/settings/sidebar-layout/none.png',
			),
			'sidebar-left'  => array(
				'name'  => esc_html__( 'Left', 'studiare-plus' ),
				'value' => 'sidebar-left',
				'image' => WOODMART_ASSETS_IMAGES . '/settings/sidebar-layout/left.png',
			),
			'sidebar-right' => array(
				'name'  => esc_html__( 'Right', 'studiare-plus' ),
				'value' => 'sidebar-right',
				'image' => WOODMART_ASSETS_IMAGES . '/settings/sidebar-layout/right.png',
			),
		),
		'default'     => 'full-width',
		'tags'        => 'sidebar left sidebar right',
		'priority'    => 40,
	)
);

Options::add_field(
	array(
		'id'          => 'sidebar_width',
		'name'        => esc_html__( 'Sidebar size', 'studiare-plus' ),
		'description' => esc_html__( 'You can set different sizes for your pages sidebar', 'studiare-plus' ),
		'group'       => esc_html__( 'Sidebar', 'studiare-plus' ),
		'type'        => 'buttons',
		'section'     => 'general_layout_section',
		'options'     => array(
			2 => array(
				'name'  => esc_html__( 'Small', 'studiare-plus' ),
				'value' => 2,
			),
			3 => array(
				'name'  => esc_html__( 'Medium', 'studiare-plus' ),
				'value' => 3,
			),
			4 => array(
				'name'  => esc_html__( 'Large', 'studiare-plus' ),
				'value' => 4,
			),
		),
		'default'     => 3,
		'tags'        => 'small sidebar large sidebar',
		'priority'    => 50,
		'class'       => 'xts-tooltip-bordered',
	)
);

Options::add_field(
	array(
		'id'          => 'hide_main_sidebar',
		'section'     => 'general_layout_section',
		'name'        => esc_html__( 'Off canvas sidebar for desktop', 'studiare-plus' ),
		'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'off-canvas-sidebar-for-mobile.mp4" autoplay loop muted></video>',
		'description' => esc_html__( 'You can hide the sidebar on desktop and show it nicely with a button click.', 'studiare-plus' ),
		'group'       => esc_html__( 'Sidebar', 'studiare-plus' ),
		'type'        => 'switcher',
		'default'     => '0',
		't_tab'       => array(
			'id'    => 'hide_main_sidebar_tabs',
			'tab'   => esc_html__( 'Desktop', 'studiare-plus' ),
			'icon'  => 'xts-i-desktop',
			'style' => 'devices',
		),
		'priority'    => 60,
	)
);

Options::add_field(
	array(
		'id'          => 'hide_main_sidebar_tablet',
		'section'     => 'general_layout_section',
		'name'        => esc_html__( 'Off canvas sidebar for tablet', 'studiare-plus' ),
		'description' => esc_html__( 'You can hide the sidebar on tablet and show it nicely with a button click.', 'studiare-plus' ),
		'group'       => esc_html__( 'Sidebar', 'studiare-plus' ),
		'type'        => 'switcher',
		'default'     => '1',
		't_tab'       => array(
			'id'   => 'hide_main_sidebar_tabs',
			'tab'  => esc_html__( 'Tablet', 'studiare-plus' ),
			'icon' => 'xts-i-tablet',
		),
		'priority'    => 61,
	)
);

Options::add_field(
	array(
		'id'          => 'hide_main_sidebar_mobile',
		'section'     => 'general_layout_section',
		'name'        => esc_html__( 'Off canvas sidebar for mobile', 'studiare-plus' ),
		'description' => esc_html__( 'You can hide the sidebar on mobile devices and show it nicely with a button click.', 'studiare-plus' ),
		'group'       => esc_html__( 'Sidebar', 'studiare-plus' ),
		'type'        => 'switcher',
		'default'     => '1',
		't_tab'       => array(
			'id'   => 'hide_main_sidebar_tabs',
			'tab'  => esc_html__( 'Mobile', 'studiare-plus' ),
			'icon' => 'xts-i-phone',
		),
		'priority'    => 62,
	)
);
