<?php
/**
 * Custom JS options
 *
 * @package xts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

use XTS\Admin\Modules\Options;

Options::add_field(
	array(
		'id'       => 'custom_js',
		'name'     => esc_html__( 'Global custom JS', 'studiare-plus' ),
		'type'     => 'editor',
		'language' => 'javascript',
		'section'  => 'custom_js',
		't_tab'    => array(
			'id'    => 'custom_js_tabs',
			'icon'  => 'xts-i-global',
			'tab'   => esc_html__( 'Global', 'studiare-plus' ),
			'style' => 'default',
		),
		'priority' => 10,
	)
);

Options::add_field(
	array(
		'id'          => 'js_ready',
		'name'        => esc_html__( 'On document ready', 'studiare-plus' ),
		'description' => esc_html__( 'Will be executed on $(document).ready()', 'studiare-plus' ),
		'type'        => 'editor',
		'language'    => 'javascript',
		'section'     => 'custom_js',
		't_tab'       => array(
			'id'  => 'custom_js_tabs',
			'tab' => esc_html__( 'On document ready', 'studiare-plus' ),
		),
		'priority'    => 20,
	)
);
