<?php if ( ! defined( 'WOODMART_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}
use XTS\Admin\Modules\Options;

/**
 * Custom CSS section.
 */
Options::add_field(
	array(
		'id'       => 'custom_css',
		'name'     => esc_html__( 'Global custom CSS', 'studiare-plus' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		't_tab'    => array(
			'id'    => 'custom_css_tabs',
			'icon'  => 'xts-i-global',
			'tab'   => esc_html__( 'Global', 'studiare-plus' ),
			'style' => 'default',
		),
		'priority' => 10,
	)
);

Options::add_field(
	array(
		'id'       => 'css_desktop',
		'name'     => esc_html__( 'Custom CSS for desktop', 'studiare-plus' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		't_tab'    => array(
			'id'  => 'custom_css_tabs',
			'icon'  => 'xts-i-desktop',
			'tab' => esc_html__( 'Desktop', 'studiare-plus' ),
		),
		'priority' => 20,

	)
);

Options::add_field(
	array(
		'id'       => 'css_tablet',
		'name'     => esc_html__( 'Custom CSS for tablet', 'studiare-plus' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		't_tab'    => array(
			'id'  => 'custom_css_tabs',
			'icon'  => 'xts-i-tablet',
			'tab' => esc_html__( 'Tablet', 'studiare-plus' ),
		),
		'priority' => 30,

	)
);

Options::add_field(
	array(
		'id'       => 'css_wide_mobile',
		'name'     => esc_html__( 'Custom CSS for mobile landscape', 'studiare-plus' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		't_tab'    => array(
			'id'  => 'custom_css_tabs',
			'icon'  => 'xts-i-phone xts-i-landscape',
			'tab' => esc_html__( 'Mobile Landscape', 'studiare-plus' ),
		),
		'priority' => 40,

	)
);

Options::add_field(
	array(
		'id'       => 'css_mobile',
		'name'     => esc_html__( 'Custom CSS for mobile', 'studiare-plus' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		't_tab'    => array(
			'id'  => 'custom_css_tabs',
			'icon'  => 'xts-i-phone',
			'tab' => esc_html__( 'Mobile', 'studiare-plus' ),
		),
		'priority' => 50,

	)
);

Options::add_field(
	array(
		'id'       => 'css_backend',
		'name'     => esc_html__( 'Custom CSS for admin dashboard', 'studiare-plus' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		't_tab'    => array(
			'id'  => 'custom_css_tabs',
			'icon'  => 'xts-i-wordpress',
			'tab' => esc_html__( 'Dashboard', 'studiare-plus' ),
		),
		'priority' => 60,
	)
);
