<?php
/**
 * Dummy content template.
 *
 * @package studiare plus
 */

use XTS\Admin\Modules\Import;
use XTS\Admin\Modules\Import\Remove;

$wrapper_classes = '';
$import_classes  = '';

if ( Import::get_instance()->is_imported( 'base' ) && Remove::get_instance()->has_data_to_remove() ) {
	$wrapper_classes .= ' imported-base';
	$import_classes  .= ' xts-active';
} else {
	$wrapper_classes .= ' xts-active';
}
?>

<div class="xts-wizard-content-inner xts-wizard-dummy<?php echo esc_attr( $wrapper_classes ); ?>">
	<?php $this->get_skip_button( 'done' ); ?>
	<?php Import::get_instance()->render(); ?>
</div>

<div class="xts-wizard-content-inner xts-wizard-import-template<?php echo esc_attr( $import_classes ); ?>">
	<h3 class="xts-import-title">
		<?php esc_html_e( 'Importing', 'studiare-plus' ); ?>
	</h3>

	<p>
		<?php esc_html_e( 'The import process includes a homepage, products, posts, projects, images, and menus.', 'studiare-plus' ); ?>
	</p>

	<div class="xts-import-item"></div>

	<ul class="xts-import-status">
		<li><?php esc_html_e( 'Importing posts', 'studiare-plus' ); ?></li>
		<li><?php esc_html_e( 'Importing products', 'studiare-plus' ); ?></li>
		<li><?php esc_html_e( 'Importing pages', 'studiare-plus' ); ?></li>
		<li><?php esc_html_e( 'Importing images', 'studiare-plus' ); ?></li>
		<li><?php esc_html_e( 'Importing menus', 'studiare-plus' ); ?></li>
		<li><?php esc_html_e( 'Importing widgets', 'studiare-plus' ); ?></li>
		<li><?php esc_html_e( 'Importing header configuration', 'studiare-plus' ); ?></li>
		<li><?php esc_html_e( 'Applying theme settings', 'studiare-plus' ); ?></li>
		<li><?php esc_html_e( 'All content has been successfully imported and is ready to use.', 'studiare-plus' ); ?></li>
	</ul>

	<div class="xts-box">
		<div class="xts-notices-wrapper xts-import-notices"></div>
	</div>

	<div class="xts-note">
		<?php
		echo wp_kses(
			__(
				'<span>Note:</span> please do not close this tab while content is being imported. This may interrupt the installation process.',
				'woodmart'
			),
			true
		);
		?>
	</div>

	<div class="xts-step-actions">
		<?php $this->get_next_button( 'done' ); ?>
	</div>
</div>

<?php $this->show_part( 'done' ); ?>
