<?php
/**
 * Page builder template.
 *
 * @package studiare plus
 */

?>

<div class="xts-wizard-content-inner xts-wizard-page-builder">

	<h3>
		<?php esc_html_e( 'Page builder', 'studiare-plus' ); ?>
	</h3>

	<p>
		<?php esc_html_e( 'Select one of the page builders below.', 'studiare-plus' ); ?>
	</p>

	<div class="xts-wizard-builder-select">
		<div class="xts-wizard-elementor xts-active" data-builder="elementor">
			<div class="xts-page-builder-img">
				<img src="<?php echo esc_url( $this->get_image_url( 'elementor-builder.svg' ) ); ?>" alt="elementor logo">
			</div>

			<div class="xts-page-builder-text">
				<div class="xts-page-builder-title">
					<?php esc_attr_e( 'Elementor', 'studiare-plus' ); ?>
				</div>

				<p>
					<?php esc_attr_e( 'The World\'s Leading WordPress Website Builder', 'studiare-plus' ); ?>
				</p>
			</div>
		</div>


	</div>

	<div class="xts-step-actions">
		<?php $this->get_next_button( 'plugins', 'elementor' ); ?>
		<?php $this->get_next_button( 'plugins', 'gutenberg' ); ?>
		<?php $this->get_next_button( 'plugins', 'wpb' ); ?>
	</div>

</div>
