<div class="xts-box xts-status xts-theme-style">
	<div class="xts-box-header">
		<h3>
			<?php esc_html_e( 'Status', 'studiare-plus' ); ?>
		</h3>
	</div>

	<div class="xts-box-content">
		<h4>
			<?php esc_html_e( 'WordPress', 'studiare-plus' ); ?>
		</h4>
		<div class="xts-table xts-odd">
			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'Theme Name', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php if ( woodmart_get_opt( 'white_label', '0' ) ) : ?>
						<?php echo esc_html( woodmart_get_opt( 'white_label_theme_name' ) ); ?>
					<?php else : ?>
						<?php echo esc_html( splus_get_theme_info( 'Name' ) ); ?>
					<?php endif; ?>
				</div>
			</div>

			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'Theme Version', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php echo esc_html( WOODMART_VERSION ); ?>
				</div>
			</div>

			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'WP Version', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php echo esc_html( get_bloginfo( 'version' ) ); ?>
				</div>
			</div>

			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'WP Multisite', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php echo is_multisite() ? esc_html__( 'Yes', 'studiare-plus' ) : esc_html__( 'No', 'studiare-plus' ); ?>
				</div>
			</div>

			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'WP Debug Mode', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php echo defined( 'WP_DEBUG' ) && WP_DEBUG ? esc_html__( 'Enabled', 'studiare-plus' ) : esc_html__( 'Disabled', 'studiare-plus' ); ?>
				</div>
			</div>
		</div>
		<h4>
			<?php esc_html_e( 'Server', 'studiare-plus' ); ?>
		</h4>
		<div class="xts-table xts-odd">

			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'PHP Version', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php if ( version_compare( PHP_VERSION, '7.2', '<' ) ) : ?>
						<div class="xts-status-error">
							<span>
								<?php echo esc_html( PHP_VERSION ); ?>
							</span>
							<span>
								<?php esc_html_e( 'Minimum required PHP version 7.2', 'studiare-plus' ); ?>
							</span>
						</div>
					<?php else : ?>
						<?php echo esc_html( PHP_VERSION ); ?>
					<?php endif; ?>
				</div>
			</div>

			<?php if ( function_exists( 'ini_get' ) ) : ?>
				<div class="xts-table-row">
					<div>
						<?php $post_max_size = ini_get( 'post_max_size' ); ?>

						<?php esc_html_e( 'PHP Post Max Size', 'studiare-plus' ); ?>:
					</div>

					<div>
						<?php if ( wp_convert_hr_to_bytes( $post_max_size ) < 64000000 ) : ?>
							<div class="xts-status-error">
								<span>
									<?php echo esc_html( $post_max_size ); ?>
								</span>
								<span>
									<?php esc_html_e( 'Minimum required value 64M.', 'studiare-plus' ); ?>
								</span>
							</div>
						<?php else : ?>
							<?php echo esc_html( $post_max_size ); ?>
						<?php endif; ?>
					</div>
				</div>

				<div class="xts-table-row">
					<div>
						<?php $max_execution_time = ini_get( 'max_execution_time' ); ?>
						<?php esc_html_e( 'PHP Time Limit', 'studiare-plus' ); ?>:
					</div>

					<div>
						<?php if ( $max_execution_time < 180 ) : ?>
							<div class="xts-status-error">
								<span>
									<?php echo esc_html( $max_execution_time ); ?>
								</span>
								<span>
									<?php esc_html_e( 'Minimum required value 180.', 'studiare-plus' ); ?>
								</span>
							</div>
						<?php else : ?>
							<?php echo esc_html( $max_execution_time ); ?>
						<?php endif; ?>
					</div>
				</div>

				<div class="xts-table-row">
					<div>
						<?php $max_input_vars = ini_get( 'max_input_vars' ); ?>
						<?php esc_html_e( 'PHP Max Input Vars', 'studiare-plus' ); ?>:
					</div>

					<div>
						<?php if ( $max_input_vars < 10000 ) : ?>
							<div class="xts-status-error">
								<span>
									<?php echo esc_html( $max_input_vars ); ?>
								</span>
								<span>
									<?php esc_html_e( 'Minimum required value 10000.', 'studiare-plus' ); ?>
								</span>
							</div>
						<?php else : ?>
							<?php echo esc_html( $max_input_vars ); ?>
						<?php endif; ?>
					</div>
				</div>

				<div class="xts-table-row">
					<div>
						<?php $memory_limit = ini_get( 'memory_limit' ); ?>
						<?php esc_html_e( 'PHP Memory Limit', 'studiare-plus' ); ?>:
					</div>

					<div>
						<?php if ( wp_convert_hr_to_bytes( $memory_limit ) < 128000000 ) : ?>
							<div class="xts-status-error">
								<span>
									<?php echo esc_html( $memory_limit ); ?>
								</span>
								<span>
									<?php esc_html_e( 'Minimum required value 128M.', 'studiare-plus' ); ?>
								</span>
							</div>
						<?php else : ?>
							<?php echo esc_html( $memory_limit ); ?>
						<?php endif; ?>
					</div>
				</div>

				<div class="xts-table-row">
					<div>
						<?php $upload_max_filesize = ini_get( 'upload_max_filesize' ); ?>
						<?php esc_html_e( 'PHP Upload Max Size', 'studiare-plus' ); ?>:
					</div>
					<div>

						<?php if ( wp_convert_hr_to_bytes( $upload_max_filesize ) < 64000000 ) : ?>
							<div class="xts-status-error">
								<span>
									<?php echo esc_html( $upload_max_filesize ); ?>
								</span>
								<span>
									<?php esc_html_e( 'Minimum required value 64M.', 'studiare-plus' ); ?>
								</span>
							</div>
						<?php else : ?>
							<?php echo esc_html( $upload_max_filesize ); ?>
						<?php endif; ?>
					</div>
				</div>

				<div class="xts-table-row">
					<div>
						<?php esc_html_e( 'PHP Function "file_get_content"', 'studiare-plus' ); ?>:
					</div>
					<div>
						<?php if ( ! ini_get( 'allow_url_fopen' ) || 'Off' === ini_get( 'allow_url_fopen' ) ) : ?>
							<div class="xts-status-error">
								<?php esc_html_e( 'Off', 'studiare-plus' ); ?>
							</div>
						<?php else : ?>
							<?php esc_html_e( 'On', 'studiare-plus' ); ?>
						<?php endif; ?>
					</div>
				</div>
			<?php endif; ?>

			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'DOMDocument', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php if ( ! class_exists( 'DOMDocument' ) ) : ?>
						<div class="xts-status-error">
							<?php esc_html_e( 'No', 'studiare-plus' ); ?>
						</div>
					<?php else : ?>
						<?php esc_html_e( 'Yes', 'studiare-plus' ); ?>
					<?php endif; ?>
				</div>
			</div>

			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'Active Plugins', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php if ( is_multisite() ) : ?>
						<?php echo esc_html( count( (array) wp_get_active_and_valid_plugins() ) + count( (array) wp_get_active_network_plugins() ) ); ?>
					<?php else : ?>
						<?php echo esc_html( count( (array) wp_get_active_and_valid_plugins() ) ); ?>
					<?php endif; ?>
				</div>
			</div>

			<div class="xts-table-row">
				<div>
					<?php esc_html_e( 'Filesystem Method', 'studiare-plus' ); ?>:
				</div>
				<div>
					<?php
					$fs_method = get_filesystem_method(); // phpcs:ignore.

					echo esc_html( $fs_method );
					?>
					<?php if ( 'direct' !== $fs_method ) : ?>
						<div class="xts-status-error">
							<span>
								<?php esc_html_e( 'It is recommended to set FS_METHOD to "direct" in wp-config.php file for proper theme functionality.', 'studiare-plus' ); ?>
							</span>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>
