<?php

global $menu;
global $submenu;

$logo_url = WOODMART_ASSETS_IMAGES . '/studiare-logo.svg';

if ( woodmart_get_opt( 'white_label' ) ) {
	$image_data = woodmart_get_opt( 'white_label_dashboard_logo' );

	if ( ! empty( $image_data['url'] ) ) {
		$logo_url = wp_get_attachment_image_url( $image_data['id'], 'full' );
	}
}

?>
<div class="xts-header xts-theme-style">
	<div class="xts-row">
		<div class="xts-col-auto xts-logo-wrap">
			<?php if ( current_user_can( apply_filters( 'woodmart_dashboard_theme_links_access', 'administrator' ) ) ) : ?>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=xts_dashboard' ) ); ?>"></a>
			<?php endif; ?>
			<img src="<?php echo esc_url( $logo_url ); ?>" class="xts-logo" alt="<?php esc_attr_e( 'Logo', 'studiare-plus' ); ?>">
			<div class="xts-version">
				<?php echo esc_html( 'v.' . splus_get_theme_info( 'Version' ) ); ?>
			</div>
		</div>
		<div class="xts-col">
			<?php
			new XTS\Admin\Modules\Dashboard\Menu(
				array(
					'items' => array(
						array(
							'link'       => array(
								'url' => admin_url( 'admin.php?page=xts_theme_settings' ),
							),
							'type'       => 'page',
							'slug'       => 'xts_theme_settings',
							'icon'       => 'theme-settings',
							'text'       => esc_html__( 'Theme settings', 'studiare-plus' ),
							'condition'  => current_user_can( apply_filters( 'woodmart_capability_menu_page', 'manage_options', 'xts_theme_settings' ) ),
							'child_menu' => array(
								'items' => array(
									array(
										'link' => array(
											'url' => admin_url( 'admin.php?page=xts_theme_settings_presets' ),
										),
										'type' => 'page',
										'slug' => 'xts_theme_settings_presets',
										'icon' => 'cog',
										'text' => esc_html__( 'Presets', 'studiare-plus' ),
									),
									array(
										'link' => array(
											'url' => admin_url( 'admin.php?page=xts_theme_settings_backup' ),
										),
										'type' => 'page',
										'slug' => 'xts_theme_settings_backup',
										'icon' => 'round-right',
										'text' => esc_html__( 'Backup', 'studiare-plus' ),
									),
								),
							),
						),

						array(
							'link'      => array(
								'url' => admin_url( 'admin.php?page=xts_license' ),
							),
							'type'      => 'page',
							'slug'      => 'xts_license',
							'icon'      => 'key',
							'text'      => esc_html__( 'Theme license', 'woodmart' ),
							
						),
			
		
						array(
							'link'       => array(
								'url' => admin_url( 'admin.php?page=xts_plugins' ),
							),
							'type'       => 'page',
							'slug'       => 'xts_plugins',
							'icon'       => 'tools',
							'text'       => esc_html__( 'Tools', 'studiare-plus' ),
							'condition'  => current_user_can( apply_filters( 'woodmart_capability_menu_page', 'manage_options', 'xts_plugins' ) ),
							'child_menu' => array(
								'items' => array(
									array(
										'link' => array(
											'url' => admin_url( 'admin.php?page=xts_plugins' ),
										),
										'type' => 'page',
										'slug' => 'xts_plugins',
										'icon' => 'puzzle',
										'text' => esc_html__( 'Plugins', 'studiare-plus' ),
									),
						
									array(
										'link' => array(
											'url' => admin_url( 'admin.php?page=xts_status' ),
										),
										'type' => 'page',
										'slug' => 'xts_status',
										'icon' => 'status',
										'text' => esc_html__( 'Status', 'studiare-plus' ),
									),
						
						
								),
							),
						),
					),
				)
			);
			?>
			<?php
			new XTS\Admin\Modules\Dashboard\Menu(
				array(
					'items' => array(
						array(
							'link'      => array(
								'url' => admin_url( 'admin.php?page=xts_header_builder' ),
							),
							'type'      => 'page',
							'slug'      => 'xts_header_builder',
							'icon'      => 'header-builder',
							'text'      => esc_html__( 'Header builder', 'studiare-plus' ),
							'condition' => current_user_can( apply_filters( 'woodmart_capability_menu_page', 'manage_options', 'xts_header_builder' ) ),
						),
						array(
							'link'       => array(
								'url' => admin_url( 'edit.php?post_type=woodmart_layout' ),
							),
							'type'       => 'post_type',
							'slug'       => 'woodmart_layout',
							'icon'       => 'layouts',
							'text'       => esc_html__( 'Layouts', 'studiare-plus' ),
							'condition'  => in_array( 'edit.php?post_type=woodmart_layout', array_column( $menu, 2 ) ),
							'child_menu' => array(
								'items' => array(
									array(
										'link'      => array(
											'url' => admin_url( 'edit.php?post_type=woodmart_layout&create_template' ),
										),
										'type'      => 'post_type_new',
										'slug'      => 'woodmart_layout',
										'condition' => in_array( 'edit.php?post_type=woodmart_layout', array_column( $menu, 2 ) ),
										'text'      => esc_html__( 'Add layout', 'studiare-plus' ),
										'class'     => 'wd-add-layout',
									),
								),
							),
						),
						array(
							'link'       => array(
								'url' => admin_url( 'edit-tags.php?taxonomy=woodmart_slider&post_type=woodmart_slide' ),
							),
							'type'       => 'post_type_taxonomy',
							'slug'       => 'woodmart_slide',
							'icon'       => 'slides',
							'text'       => esc_html__( 'Sliders', 'studiare-plus' ),
							'condition'  => woodmart_get_opt( 'woodmart_slider', '1' ) && in_array( 'edit.php?post_type=woodmart_slide', array_column( $menu, 2 ) ),
							'child_menu' => array(
								'items' => array(
									array(
										'link'      => array(
											'url' => admin_url( 'edit.php?post_type=woodmart_slide' ),
										),
										'type'      => 'post_type',
										'slug'      => 'woodmart_slide',
										'condition' => woodmart_get_opt( 'woodmart_slider', '1' ) && isset( $submenu['edit.php?post_type=woodmart_slide'] ),
										'text'      => esc_html__( 'All slides', 'studiare-plus' ),
									),
									array(
										'link'      => array(
											'url' => admin_url( 'post-new.php?post_type=woodmart_slide' ),
										),
										'type'      => 'post_type_new',
										'slug'      => 'woodmart_slide',
										'condition' => woodmart_get_opt( 'woodmart_slider', '1' ) && isset( $submenu['edit.php?post_type=woodmart_slide'] ),
										'text'      => esc_html__( 'Add slide', 'studiare-plus' ),
									),
								),
							),
						),
						array(
							'link'       => array(
								'url' => admin_url( 'edit.php?post_type=cms_block' ),
							),
							'type'       => 'post_type',
							'slug'       => 'cms_block',
							'icon'       => 'html-block',
							'condition'  => in_array( 'edit.php?post_type=cms_block', array_column( $menu, 2 ) ),
							'text'       => esc_html__( 'HTML Blocks', 'studiare-plus' ),
							'child_menu' => array(
								'items' => array(
									array(
										'link'      => array(
											'url' => admin_url( 'post-new.php?post_type=cms_block' ),
										),
										'type'      => 'post_type_new',
										'slug'      => 'cms_block',
										'condition' => isset( $submenu['edit.php?post_type=cms_block'] ),
										'text'      => esc_html__( 'Add block', 'studiare-plus' ),
									),
									array(
										'link'      => array(
											'url' => admin_url( 'edit-tags.php?taxonomy=cms_block_cat&post_type=cms_block' ),
										),
										'type'      => 'post_type_taxonomy',
										'slug'      => 'cms_block',
										'condition' => isset( $submenu['edit.php?post_type=cms_block'] ),
										'text'      => esc_html__( 'Categories', 'studiare-plus' ),
									),
								),
							),
						),
						array(
							'link'       => array(
								'url' => admin_url( 'edit.php?post_type=cms_lesson' ),
							),
							'type'       => 'post_type',
							'slug'       => 'cms_lesson',
							'icon'       => 'slides',
							'condition'  => in_array( 'edit.php?post_type=cms_lesson', array_column( $menu, 2 ) ),
							'text'       => esc_html__( 'جلسات دوره ها', 'studiare-plus' ),
							'child_menu' => array(
								'items' => array(
									array(
										'link'      => array(
											'url' => admin_url( 'post-new.php?post_type=cms_lesson' ),
										),
										'type'      => 'post_type_new',
										'slug'      => 'cms_lesson',
										'condition' => isset( $submenu['edit.php?post_type=cms_lesson'] ),
										'text'      => esc_html__( 'افزودن جلسه', 'studiare-plus' ),
									),
									array(
										'link'      => array(
											'url' => admin_url( 'edit-tags.php?taxonomy=cms_block_cat&post_type=cms_block' ),
										),
										'type'      => 'post_type_taxonomy',
										'slug'      => 'cms_lesson',
										'condition' => isset( $submenu['edit.php?post_type=cms_lesson'] ),
										'text'      => esc_html__( 'Categories', 'studiare-plus' ),
									),
								),
							),
						),
						array(
							'link'       => array(
								'url' => admin_url( 'edit.php?post_type=wd_popup' ),
							),
							'type'       => 'post_type',
							'slug'       => 'wd_popup',
							'icon'       => 'popup',
							'text'       => esc_html__( 'Popups', 'studiare-plus' ),
							'condition'  => in_array( 'edit.php?post_type=wd_popup', array_column( $menu, 2 ) ),
							'child_menu' => array(
								'items' => array(
									array(
										'link'      => array(
											'url' => admin_url( 'edit.php?post_type=wd_popup&create_template' ),
										),
										'type'      => 'post_type_new',
										'slug'      => 'wd_popup',
										'condition' => isset( $submenu['edit.php?post_type=wd_popup'] ),
										'text'      => esc_html__( 'Add popup', 'studiare-plus' ),
										'class'     => 'wd-add-popup',
									),
									array(
										'link'      => array(
											'url' => admin_url( 'edit-tags.php?taxonomy=wd_popup_cat&post_type=wd_popup' ),
										),
										'type'      => 'post_type_taxonomy',
										'slug'      => 'wd_popup_cat',
										'condition' => isset( $submenu['edit.php?post_type=wd_popup'] ),
										'text'      => esc_html__( 'Categories', 'studiare-plus' ),
									),
								),
							),
						),
						array(
							'link'       => array(
								'url' => admin_url( 'edit.php?post_type=wd_floating_block' ),
							),
							'type'       => 'post_type',
							'slug'       => 'wd_floating_block',
							'icon'       => 'fb',
							'text'       => esc_html__( 'Floating Blocks', 'studiare-plus' ),
							'condition'  => in_array( 'edit.php?post_type=wd_floating_block', array_column( $menu, 2 ) ),
							'child_menu' => array(
								'items' => array(
									array(
										'link'      => array(
											'url' => admin_url( 'edit.php?post_type=wd_floating_block&create_template' ),
										),
										'type'      => 'post_type_new',
										'slug'      => 'wd_floating_block',
										'condition' => isset( $submenu['edit.php?post_type=wd_popup'] ),
										'text'      => esc_html__( 'Add block', 'studiare-plus' ),
										'class'     => 'wd-add-floating-block',
									),
									array(
										'link'      => array(
											'url' => admin_url( 'edit-tags.php?taxonomy=wd_floating_block_cat&post_type=wd_floating_block' ),
										),
										'type'      => 'post_type_taxonomy',
										'slug'      => 'wd_floating_block_cat',
										'condition' => isset( $submenu['edit.php?post_type=wd_floating_block'] ),
										'text'      => esc_html__( 'Categories', 'studiare-plus' ),
									),
								),
							),
						),
						array(
							'link'       => array(
								'url' => admin_url( 'edit.php?post_type=woodmart_sidebar' ),
							),
							'type'       => 'post_type',
							'slug'       => 'woodmart_sidebar',
							'icon'       => 'sidebars',
							'condition'  => in_array( 'edit.php?post_type=woodmart_sidebar', array_column( $menu, 2 ) ),
							'text'       => esc_html__( 'Sidebars', 'studiare-plus' ),
							'child_menu' => array(
								'items' => array(
									array(
										'link'      => array(
											'url' => admin_url( 'post-new.php?post_type=woodmart_sidebar' ),
										),
										'type'      => 'post_type_new',
										'slug'      => 'woodmart_sidebar',
										'condition' => isset( $submenu['edit.php?post_type=woodmart_sidebar'] ),
										'text'      => esc_html__( 'Add sidebar', 'studiare-plus' ),
									),
								),
							),
						),
					),
				)
			);
			?>
		</div>
	</div>
</div>
