<div class="xts-welcome-page">

	<?php if ( woodmart_get_opt( 'white_label' ) ) : ?>
		<div class="xts-box xts-white-label-box xts-theme-style">
			<div class="xts-box-content">
				<h3>
					<?php if ( woodmart_get_opt( 'white_label_dashboard_title' ) ) : ?>
						<?php echo esc_html( woodmart_get_opt( 'white_label_dashboard_title' ) ); ?>
					<?php else : ?>
						<?php esc_html_e( 'Welcome to WoodMart dashboard', 'studiare-plus' ); ?>
					<?php endif; ?>
				</h3>
				<div class="xts-about-text">
					<?php if ( woodmart_get_opt( 'white_label_dashboard_text' ) ) : ?>
						<?php echo do_shortcode( wpautop( woodmart_get_opt( 'white_label_dashboard_text' ) ) ); ?>
					<?php else : ?>
						<?php esc_html_e( 'Thank you for choosing WoodMart, our premium eCommerce theme! Get started building your stunning online store by easily importing one of our prebuilt demo sites and customizing the theme options to match your needs.', 'studiare-plus' ); ?>
					<?php endif; ?>
				</div>
			</div>
		</div>
	<?php else : ?>
		<div class="xts-box xts-welcome-box xts-theme-style xts-color-scheme-light">
			<div class="xts-box-content">
				

				<h3>
					<?php esc_html_e( 'Welcome to WoodMart', 'studiare-plus' ); ?>
				</h3>

				<p>
					<?php esc_html_e( 'Thank you for choosing WoodMart, our premium eCommerce theme! Get started building your stunning online store by easily importing one of our prebuilt demo sites and customizing the theme options to match your needs.', 'studiare-plus' ); ?>
				</p>

			
			</div>
		</div>

		
		<div class="xts-row xts-welcome-row xts-sp-20 xts-theme-style">
			<?php do_action( 'woodmart_after_welcome_box_content' ); ?>

			<div class="xts-col-12 xts-col-xl-6">
				<div class="xts-box xts-info-boxes xts-support xts-align-center">
					<div class="xts-box-content">
						<h4>
							<?php esc_html_e( 'Need assistance?', 'studiare-plus' ); ?>
						</h4>

						<p>
							<?php esc_html_e( 'Check out these links for more information and support!', 'studiare-plus' ); ?>
						</p>

						<div class="xts-row">
							<div class="xts-col">
								<div class="xts-info-box-img">
									<img src="<?php echo esc_url( WOODMART_ASSETS_IMAGES . '/dashboard/docs.jpg' ); ?>" alt="documentation banner">
								</div>
								<a href="#" class="xts-bordered-btn xts-color-default" target="_blank">
									<?php esc_html_e( 'Documentation', 'studiare-plus' ); ?>
								</a>
							</div>

							<div class="xts-col">
								<div class="xts-info-box-img">
									<img src="<?php echo esc_url( WOODMART_ASSETS_IMAGES . '/dashboard/video.jpg' ); ?>" alt="video banner">
								</div>
								<a href="#" class="xts-bordered-btn xts-color-default" target="_blank">
									<?php esc_html_e( 'Video tutorials', 'studiare-plus' ); ?>
								</a>
							</div>

							<div class="xts-col">
								<div class="xts-info-box-img">
									<img src="<?php echo esc_url( WOODMART_ASSETS_IMAGES . '/dashboard/forum.jpg' ); ?>" alt="forum banner">
								</div>
								<a href="#" class="xts-bordered-btn xts-color-default" target="_blank">
									<?php esc_html_e( 'پشتیبانی محصول', 'studiare-plus' ); ?>
								</a>
							</div>
						</div>
					</div>
				</div>
				<div class="xts-box xts-info-boxes xts-rate xts-align-center">
					<div class="xts-box-content">
						<h4>
							<?php esc_html_e( 'Enjoying the theme?', 'studiare-plus' ); ?>
						</h4>

						<p>
							<?php esc_html_e( 'Share your thoughts by leaving a comment on ThemeForest.', 'studiare-plus' ); ?>
						</p>

						<div class="xts-row">
							<div class="xts-col">
								<div class="xts-info-box-img">
									<img src="<?php echo esc_url( WOODMART_ASSETS_IMAGES . '/dashboard/vote.jpg' ); ?>" alt="vote banner">
								</div>
								<a href="#" class="xts-bordered-btn xts-color-default" target="_blank">
									<?php esc_html_e( 'Rate our theme', 'studiare-plus' ); ?>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php endif; ?>

</div>