<?php
/**
 * Product metaboxes
 *
 * @package xts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

use XTS\Admin\Modules\Options\Metaboxes;

if ( ! function_exists( 'woodmart_register_product_metaboxes' ) ) {
	/**
	 * Register page metaboxes
	 *
	 * @since 1.0.0
	 */
	function woodmart_register_product_metaboxes() {
		global $woodmart_transfer_options, $woodmart_prefix;

		$woodmart_prefix = '_woodmart_';

		$product_metabox = Metaboxes::add_metabox(
			array(
				'id'         => 'xts_product_metaboxes',
				'title'      => esc_html__( 'Product Setting (custom metabox from theme)', 'studiare-plus' ),
				'post_types' => array( 'product' ),
			)
		);

		$product_metabox->add_section(
			array(
				'id'       => 'product_general_section',
				'name'     => esc_html__( 'General', 'studiare-plus' ),
				'icon'     => 'xts-i-cog',
				'priority' => 10,
			)
		);

		$product_metabox->add_section(
			array(
				'id'       => 'layout_options_section',
				'name'     => esc_html__( 'Layout', 'studiare-plus' ),
				'icon'     => 'xts-i-layout',
				'priority' => 15,
			)
		);

		$product_metabox->add_section(
			array(
				'id'       => 'design_color_options_section',
				'name'     => esc_html__( 'Style', 'studiare-plus' ),
				'icon'     => 'xts-i-brush',
				'priority' => 20,
			)
		);

		$product_metabox->add_section(
			array(
				'id'       => 'sidebar_options_section',
				'name'     => esc_html__( 'Sidebar', 'studiare-plus' ),
				'icon'     => 'xts-i-sidebars',
				'priority' => 30,
			)
		);

		$product_metabox->add_section(
			array(
				'id'       => 'tab_options_section',
				'name'     => esc_html__( 'Tabs', 'studiare-plus' ),
				'icon'     => 'xts-i-footer',
				'priority' => 50,
			)
		);

		$product_metabox->add_section(
			array(
				'id'       => 'lesson_options_section',
				'name'     => esc_html__( 'جلسات دوره', 'studiare-plus' ),
				'icon'     => 'xts-i-archive',
				'priority' => 60,
			)
		);

		$product_metabox->add_section(
			array(
				'id'       => 'lesson_file_section',
				'name'     => esc_html__( 'فروش فایل', 'studiare-plus' ),
				'icon'     => 'xts-i-archive',
				'priority' => 60,
			)
		);




		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'product_preview',
				'type'        => 'text_input',
				'name'        => esc_html__( 'لینک پیشنمایش محصول', 'woodmart' ),
				'section'     => 'lesson_file_section',
				'priority'    => 10,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'product_preview_text',
				'type'        => 'text_input',
				'name'        => esc_html__( 'متن دکمه پیشنمایش', 'woodmart' ),
				'section'     => 'lesson_file_section',
				'priority'    => 9,
			)
		);
		
		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'iconimage',
				'type'        => 'upload',
				'name'        => esc_html__( 'تصویر آیکون محصول', 'woodmart' ),
				'description' => esc_html__( 'یک تصویر برای آیکون محصول آپلود کنید.', 'woodmart' ),
				'section'     => 'lesson_file_section',
				'priority'    => 20,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_medal_tab_html_block',
				'type'         => 'select',
				'section'      => 'lesson_file_section',
				'name'         => esc_html__( 'مدال های محصول', 'studiare-plus' ),
				'select2'      => true,
				'multiple'    => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'cms_medal',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
	
				'priority'     => 30,
			)
		);


		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'new_label',
				'type'        => 'checkbox',
				'name'        => esc_html__( 'Permanent "New" label', 'studiare-plus' ),
				'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'permanent-new-label.jpg" alt="">', true ),
				'description' => esc_html__( 'Enable this option to make your product have "New" status forever.', 'studiare-plus' ),
				'section'     => 'product_general_section',
				'priority'    => 10,
				'class'       => 'xts-col-6',
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'new_label_date',
				'type'        => 'text_input',
				'name'        => esc_html__( 'Mark product as "New" till date', 'studiare-plus' ),
				'description' => esc_html__( 'Specify the end date when the "New" status will be retired. NOTE: "Permanent "New" label" option should be disabled if you use the exact date.', 'studiare-plus' ),
				'section'     => 'product_general_section',
				'datepicker'  => true,
				'priority'    => 20,
				'class'       => 'xts-col-6',
			)
		);

		$taxonomies_list = array(
			'' => array(
				'name'  => esc_html__( 'Select', 'studiare-plus' ),
				'value' => '',
			),
		);
		$taxonomies      = get_taxonomies();
		foreach ( $taxonomies as $taxonomy ) {
			$taxonomies_list[ $taxonomy ] = array(
				'name'  => $taxonomy,
				'value' => $taxonomy,
			);
		}

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'swatches_attribute',
				'type'        => 'select',
				'name'        => esc_html__( 'Grid swatch attribute to display', 'studiare-plus' ),
				'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'grid-swatch-attribute-to-display.mp4" autoplay loop muted></video>',
				'description' => esc_html__( 'Choose attribute that will be shown on products grid for this particular product', 'studiare-plus' ),
				'section'     => 'product_general_section',
				'options'     => $taxonomies_list,
				'priority'    => 30,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'related_off',
				'type'        => 'checkbox',
				'name'        => esc_html__( 'Hide related products', 'studiare-plus' ),
				'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'show-related-products.jpg" alt="">', true ),
				'description' => esc_html__( 'You can hide related products on this page', 'studiare-plus' ),
				'section'     => 'product_general_section',
				'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text'    => esc_html__( 'No', 'studiare-plus' ),
				'priority'    => 40,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'exclude_show_single_variation',
				'type'     => 'checkbox',
				'name'     => esc_html__( 'Exclude variation products on grid', 'studiare-plus' ),
				'section'  => 'product_general_section',
				'on-text'  => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text' => esc_html__( 'No', 'studiare-plus' ),
				'priority' => 45,
				'class'    => 'xts-col-6',
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'product_video',
				'type'        => 'text_input',
				'name'        => esc_html__( 'Product video URL', 'studiare-plus' ),
				'hint'        => '<video data-src="' . WOODMART_TOOLTIP_URL . 'product-video-url.mp4" autoplay loop muted></video>',
				'description' => esc_html__( 'URL example: https://www.youtube.com/watch?v=LXb3EKWsInQ', 'studiare-plus' ),
				'section'     => 'product_general_section',
				'priority'    => 50,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'product_hashtag',
				'type'        => 'text_input',
				'name'        => esc_html__( 'Instagram product hashtag (deprecated)', 'studiare-plus' ),
				'description' => wp_kses( __( 'Insert tag that will be used to display images from instagram from your customers. For example: <strong>#nike_rush_run</strong>', 'studiare-plus' ), 'default' ),
				'section'     => 'product_general_section',
				'class'       => 'xts-hidden',
				'priority'    => 60,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'single_product_style',
				'name'        => esc_html__( 'Product page layout', 'studiare-plus' ),
				'description' => esc_html__( 'You can choose different page layout depending on the product image size you need.', 'studiare-plus' ),
				'type'        => 'select',
				'section'     => 'layout_options_section',
				'options'     => array(
					'inherit' => array(
						'name'  => esc_html__( 'Inherit', 'studiare-plus' ),
						'value' => 'inherit',
					),
					1         => array(
						'name'  => esc_html__( 'Small image', 'studiare-plus' ),
						'value' => 1,
					),
					2         => array(
						'name'  => esc_html__( 'Medium', 'studiare-plus' ),
						'value' => 2,
					),
					3         => array(
						'name'  => esc_html__( 'Large', 'studiare-plus' ),
						'value' => 3,
					),
					4         => array(
						'name'  => esc_html__( 'Full width (container)', 'studiare-plus' ),
						'value' => 4,
					),
					5         => array(
						'name'  => esc_html__( 'Full width (window)', 'studiare-plus' ),
						'value' => 5,
					),
				),
				'default'     => 'inherit',
				'priority'    => 10,
			)
		);

		$product_metabox->add_field(
			array(
				'id'                 => $woodmart_prefix . 'thums_position',
				'name'               => esc_html__( 'Thumbnails position', 'studiare-plus' ),
				'type'               => 'select',
				'section'            => 'layout_options_section',
				'options'            => array(
					'inherit'         => array(
						'name'  => esc_html__( 'Inherit', 'studiare-plus' ),
						'value' => 'inherit',
					),
					'left'            => array(
						'name'  => esc_html__( 'Left (vertical position)', 'studiare-plus' ),
						'value' => 'left',
					),
					'bottom'          => array(
						'name'  => esc_html__( 'Bottom (horizontal carousel)', 'studiare-plus' ),
						'value' => 'bottom',
					),
					'bottom_column'   => array(
						'name'  => esc_html__( 'Bottom (1 column)', 'studiare-plus' ),
						'value' => 'left',
					),
					'bottom_grid'     => array(
						'name'  => esc_html__( 'Bottom (2 columns)', 'studiare-plus' ),
						'value' => 'left',
					),
					'bottom_combined' => array(
						'name'  => esc_html__( 'Combined grid (1:2:1)', 'studiare-plus' ),
						'value' => 'bottom_combined',
					),
					'without'         => array(
						'name'  => esc_html__( 'Without', 'studiare-plus' ),
						'value' => 'without',
					),
				),
				'status'             => 'deprecated',
				'status_description' => esc_html__( 'This option is deprecated. You can now use "Layouts" or "Theme settings presets" to change one or several individual product pages.', 'studiare-plus' ),
				'default'            => 'inherit',
				'priority'           => 20,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'whb_header',
				'name'        => esc_html__( 'Custom header for this product', 'studiare-plus' ),
				'description' => esc_html__( 'You can select a different header from the list for this particular product.', 'studiare-plus' ),
				'type'        => 'select',
				'section'     => 'layout_options_section',
				'options'     => '',
				'callback'    => 'woodmart_get_theme_settings_headers_array',
				'default'     => 'none',
				'priority'    => 9,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'extra_content',
				'name'         => esc_html__( 'Extra content block', 'studiare-plus' ),
				'description'  => esc_html__( 'You can create some extra content with page builder (in Admin panel / HTML Blocks / Add new) and add it to this product', 'studiare-plus' ),
				'type'         => 'select',
				'section'      => 'layout_options_section',
				'select2'      => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'cms_block',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				'priority'     => 30,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'extra_position',
				'name'     => esc_html__( 'Extra content position', 'studiare-plus' ),
				'type'     => 'buttons',
				'section'  => 'layout_options_section',
				'options'  => array(
					'after'     => array(
						'name'  => esc_html__( 'After content', 'studiare-plus' ),
						'hint'  => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'extra-content-position-affter-content.jpg" alt="">', true ),
						'value' => 'after',
					),
					'before'    => array(
						'name'  => esc_html__( 'Before content', 'studiare-plus' ),
						'hint'  => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'extra-content-position-before-content.jpg" alt="">', true ),
						'value' => 'before',
					),
					'prefooter' => array(
						'name'  => esc_html__( 'Prefooter', 'studiare-plus' ),
						'hint'  => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'extra-content-position-prefooter.jpg" alt="">', true ),
						'value' => 'prefooter',
					),
				),
				'default'  => 'after',
				'priority' => 40,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'product_design',
				'name'        => esc_html__( 'Product page design', 'studiare-plus' ),
				'description' => esc_html__( 'Choose between different predefined designs.', 'studiare-plus' ),
				'type'        => 'buttons',
				'section'     => 'design_color_options_section',
				'options'     => array(
					'inherit' => array(
						'name'  => esc_html__( 'Inherit', 'studiare-plus' ),
						'value' => 'inherit',
					),
					'default' => array(
						'name'  => esc_html__( 'Default', 'studiare-plus' ),
						'value' => 'default',
					),
					'alt'     => array(
						'name'  => esc_html__( 'Centered', 'studiare-plus' ),
						'value' => 'default',
					),
				),
				'default'     => 'inherit',
				'priority'    => 10,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'product-background',
				'name'        => esc_html__( 'Product background', 'studiare-plus' ),
				'description' => esc_html__( 'Set background for this particular product page.', 'studiare-plus' ),
				'type'        => 'color',
				'section'     => 'design_color_options_section',
				'data_type'   => 'hex',
				'priority'    => 20,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'main_layout',
				'name'        => esc_html__( 'Sidebar position', 'studiare-plus' ),
				'description' => esc_html__( 'Select main content and sidebar alignment.', 'studiare-plus' ),
				'type'        => 'buttons',
				'section'     => 'sidebar_options_section',
				'options'     => array(
					'default'       => array(
						'name'  => esc_html__( 'Inherit', 'studiare-plus' ),
						'value' => 'default',
					),
					'full-width'    => array(
						'name'  => esc_html__( 'Without', 'studiare-plus' ),
						'value' => 'full-width',
					),
					'sidebar-left'  => array(
						'name'  => esc_html__( 'Left', 'studiare-plus' ),
						'value' => 'sidebar-left',
					),
					'sidebar-right' => array(
						'name'  => esc_html__( 'Right', 'studiare-plus' ),
						'value' => 'sidebar-right',
					),
				),
				'default'     => 'default',
				'priority'    => 10,
			)
		);

		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'sidebar_width',
				'name'        => esc_html__( 'Sidebar size', 'studiare-plus' ),
				'description' => esc_html__( 'You can set different sizes for your pages sidebar', 'studiare-plus' ),
				'type'        => 'buttons',
				'section'     => 'sidebar_options_section',
				'options'     => array(
					'default' => array(
						'name'  => esc_html__( 'Inherit', 'studiare-plus' ),
						'value' => 'default',
					),
					2         => array(
						'name'  => esc_html__( 'Small', 'studiare-plus' ),
						'value' => 2,
					),
					3         => array(
						'name'  => esc_html__( 'Medium', 'studiare-plus' ),
						'value' => 3,
					),
					4         => array(
						'name'  => esc_html__( 'Large', 'studiare-plus' ),
						'value' => 4,
					),
				),
				'default'     => 'default',
				'priority'    => 20,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'custom_sidebar',
				'name'     => esc_html__( 'Custom sidebar for this product', 'studiare-plus' ),
				'type'     => 'select',
				'section'  => 'sidebar_options_section',
				'options'  => '',
				'callback' => 'woodmart_get_theme_settings_sidebars_array',
				'default'  => 'none',
				'priority' => 30,
			)
		);





		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_lesson_tab_title',
				'type'     => 'text_input',
				'name'     => esc_html__( 'عنوان سفارشی تب جلسات دوره', 'studiare-plus' ),
				'section'  => 'lesson_options_section',
				'class'    => 'xts-col-6',
				'priority' => 10,
			)
		);

		$product_metabox->add_field(
			array(
				'id'         => $woodmart_prefix . 'product_lesson_tab_priority',
				'type'       => 'text_input',
				'name'       => esc_html__( 'Priority', 'studiare-plus' ),
				'section'    => 'lesson_options_section',
				'attributes' => array(
					'type'        => 'number',
					'min'         => '1',
					'placeholder' => '80',
				),
				'class'      => 'xts-col-6',
				'priority'   => 25,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_lesson_tab_html_block',
				'type'         => 'select',
				'section'      => 'lesson_options_section',
				'name'         => esc_html__( 'جلسات دوره', 'studiare-plus' ),
				'select2'      => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'cms_lesson',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				'class'      => 'xts-col-6',
				'priority'     => 40,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_teachers',
				'type'         => 'select',
				'section'      => 'lesson_options_section',
				'name'         => esc_html__( 'اساتید دوره', 'studiare-plus' ),
				'select2'      => true,
				'multiple'    => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'teacher',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				'class'      => 'xts-col-6',
				'priority'     => 45,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_lesson_add_to_cart_text',
				'type'     => 'text_input',
				'name'     => esc_html__( 'عنوان سفارشی دکمه ثبت نام دوره', 'studiare-plus' ),
				'section'  => 'lesson_options_section',
				'class'    => 'xts-col-6',
				'priority' => 50,
			)
		);







		$product_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'hide_tabs_titles',
				'type'        => 'checkbox',
				'name'        => esc_html__( 'Hide tabs headings', 'studiare-plus' ),
				'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'hide-tabs-headings.jpg" alt="">', true ),
				'description' => esc_html__( 'Description and Additional information', 'studiare-plus' ),
				'section'     => 'tab_options_section',
				'on-text'     => esc_html__( 'Yes', 'studiare-plus' ),
				'off-text'    => esc_html__( 'No', 'studiare-plus' ),
				'priority'    => 10,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_title',
				'type'     => 'text_input',
				'name'     => esc_html__( 'Custom tab title', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'    => 'custom_tabs',
					'tab'   => esc_html__( 'Tab [1]', 'studiare-plus' ),
					'style' => 'default',
				),
				'class'    => 'xts-col-6',
				'priority' => 20,
			)
		);

		$product_metabox->add_field(
			array(
				'id'         => $woodmart_prefix . 'product_custom_tab_priority',
				'type'       => 'text_input',
				'name'       => esc_html__( 'Priority', 'studiare-plus' ),
				'section'    => 'tab_options_section',
				'attributes' => array(
					'type'        => 'number',
					'min'         => '1',
					'placeholder' => '80',
				),
				't_tab'      => array(
					'id'    => 'custom_tabs',
					'tab'   => esc_html__( 'Tab [1]', 'studiare-plus' ),
					'style' => 'default',
				),
				'class'      => 'xts-col-6',
				'priority'   => 25,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_type',
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'type'     => 'buttons',
				'options'  => array(
					'text'       => array(
						'name'  => esc_html__( 'Text', 'studiare-plus' ),
						'value' => 'text',
					),
					'html_block' => array(
						'name'  => esc_html__( 'HTML Block', 'studiare-plus' ),
						'value' => 'html_block',
					),
				),
				'default'  => 'text',
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'    => 'custom_tabs',
					'tab'   => esc_html__( 'Tab [1]', 'studiare-plus' ),
					'style' => 'default',
				),
				'class'    => 'xts-html-block-switch',
				'priority' => 30,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content',
				'type'     => 'textarea',
				'wysiwyg'  => true,
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [1]', 'studiare-plus' ),
				),
				'requires' => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type',
						'compare' => 'equals',
						'value'   => 'text',
					),
				),
				'priority' => 40,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_custom_tab_html_block',
				'type'         => 'select',
				'section'      => 'tab_options_section',
				'name'         => esc_html__( 'HTML Block', 'studiare-plus' ),
				'select2'      => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'cms_block',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				't_tab'        => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [1]', 'studiare-plus' ),
				),
				'requires'     => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type',
						'compare' => 'equals',
						'value'   => 'html_block',
					),
				),
				'priority'     => 50,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_title_2',
				'type'     => 'text_input',
				'name'     => esc_html__( 'Custom tab title', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [2]', 'studiare-plus' ),
				),
				'class'    => 'xts-col-6',
				'priority' => 60,
			)
		);

		$product_metabox->add_field(
			array(
				'id'         => $woodmart_prefix . 'product_custom_tab_priority_2',
				'type'       => 'text_input',
				'name'       => esc_html__( 'Priority', 'studiare-plus' ),
				'section'    => 'tab_options_section',
				'attributes' => array(
					'type'        => 'number',
					'min'         => '1',
					'placeholder' => '90',
				),
				't_tab'      => array(
					'id'    => 'custom_tabs',
					'tab'   => esc_html__( 'Tab [2]', 'studiare-plus' ),
					'style' => 'default',
				),
				'class'      => 'xts-col-6',
				'priority'   => 65,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_type_2',
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'type'     => 'buttons',
				'options'  => array(
					'text'       => array(
						'name'  => esc_html__( 'Text', 'studiare-plus' ),
						'value' => 'text',
					),
					'html_block' => array(
						'name'  => esc_html__( 'HTML Block', 'studiare-plus' ),
						'value' => 'html_block',
					),
				),
				'default'  => 'text',
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [2]', 'studiare-plus' ),
				),
				'class'    => 'xts-html-block-switch',
				'priority' => 70,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_2',
				'type'     => 'textarea',
				'wysiwyg'  => true,
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [2]', 'studiare-plus' ),
				),
				'requires' => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type_2',
						'compare' => 'equals',
						'value'   => 'text',
					),
				),
				'priority' => 80,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_custom_tab_html_block_2',
				'type'         => 'select',
				'section'      => 'tab_options_section',
				'name'         => esc_html__( 'HTML Block', 'studiare-plus' ),
				'select2'      => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'cms_block',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				't_tab'        => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [2]', 'studiare-plus' ),
				),
				'requires'     => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type_2',
						'compare' => 'equals',
						'value'   => 'html_block',
					),
				),
				'priority'     => 90,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_title_3',
				'type'     => 'text_input',
				'name'     => esc_html__( 'Custom tab title', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [3]', 'studiare-plus' ),
				),
				'class'    => 'xts-col-6',
				'priority' => 100,
			)
		);

		$product_metabox->add_field(
			array(
				'id'         => $woodmart_prefix . 'product_custom_tab_priority_3',
				'type'       => 'text_input',
				'name'       => esc_html__( 'Priority', 'studiare-plus' ),
				'section'    => 'tab_options_section',
				'attributes' => array(
					'type'        => 'number',
					'min'         => '1',
					'placeholder' => '100',
				),
				't_tab'      => array(
					'id'    => 'custom_tabs',
					'tab'   => esc_html__( 'Tab [3]', 'studiare-plus' ),
					'style' => 'default',
				),
				'class'      => 'xts-col-6',
				'priority'   => 105,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_type_3',
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'type'     => 'buttons',
				'options'  => array(
					'text'       => array(
						'name'  => esc_html__( 'Text', 'studiare-plus' ),
						'value' => 'text',
					),
					'html_block' => array(
						'name'  => esc_html__( 'HTML Block', 'studiare-plus' ),
						'value' => 'html_block',
					),
				),
				'default'  => 'text',
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [3]', 'studiare-plus' ),
				),
				'class'    => 'xts-html-block-switch',
				'priority' => 110,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_3',
				'type'     => 'textarea',
				'wysiwyg'  => true,
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [3]', 'studiare-plus' ),
				),
				'requires' => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type_3',
						'compare' => 'equals',
						'value'   => 'text',
					),
				),
				'priority' => 120,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_custom_tab_html_block_3',
				'type'         => 'select',
				'section'      => 'tab_options_section',
				'name'         => esc_html__( 'HTML Block', 'studiare-plus' ),
				'select2'      => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'cms_block',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				't_tab'        => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [3]', 'studiare-plus' ),
				),
				'requires'     => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type_3',
						'compare' => 'equals',
						'value'   => 'html_block',
					),
				),
				'priority'     => 130,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_title_4',
				'type'     => 'text_input',
				'name'     => esc_html__( 'Custom tab title', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [4]', 'studiare-plus' ),
				),
				'class'    => 'xts-col-6',
				'priority' => 140,
			)
		);

		$product_metabox->add_field(
			array(
				'id'         => $woodmart_prefix . 'product_custom_tab_priority_4',
				'type'       => 'text_input',
				'name'       => esc_html__( 'Priority', 'studiare-plus' ),
				'section'    => 'tab_options_section',
				'attributes' => array(
					'type'        => 'number',
					'min'         => '1',
					'placeholder' => '110',
				),
				't_tab'      => array(
					'id'    => 'custom_tabs',
					'tab'   => esc_html__( 'Tab [4]', 'studiare-plus' ),
					'style' => 'default',
				),
				'class'      => 'xts-col-6',
				'priority'   => 145,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_type_4',
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'type'     => 'buttons',
				'options'  => array(
					'text'       => array(
						'name'  => esc_html__( 'Text', 'studiare-plus' ),
						'value' => 'text',
					),
					'html_block' => array(
						'name'  => esc_html__( 'HTML Block', 'studiare-plus' ),
						'value' => 'html_block',
					),
				),
				'default'  => 'text',
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [4]', 'studiare-plus' ),
				),
				'class'    => 'xts-html-block-switch',
				'priority' => 150,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_4',
				'type'     => 'textarea',
				'wysiwyg'  => true,
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [4]', 'studiare-plus' ),
				),
				'requires' => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type_4',
						'compare' => 'equals',
						'value'   => 'text',
					),
				),
				'priority' => 160,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_custom_tab_html_block_4',
				'type'         => 'select',
				'section'      => 'tab_options_section',
				'name'         => esc_html__( 'HTML Block', 'studiare-plus' ),
				'select2'      => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'cms_block',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				't_tab'        => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [4]', 'studiare-plus' ),
				),
				'requires'     => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type_4',
						'compare' => 'equals',
						'value'   => 'html_block',
					),
				),
				'priority'     => 170,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_title_5',
				'type'     => 'text_input',
				'name'     => esc_html__( 'Custom tab title', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [5]', 'studiare-plus' ),
				),
				'class'    => 'xts-col-6',
				'priority' => 180,
			)
		);

		$product_metabox->add_field(
			array(
				'id'         => $woodmart_prefix . 'product_custom_tab_priority_5',
				'type'       => 'text_input',
				'name'       => esc_html__( 'Priority', 'studiare-plus' ),
				'section'    => 'tab_options_section',
				'attributes' => array(
					'type'        => 'number',
					'min'         => '1',
					'placeholder' => '120',
				),
				't_tab'      => array(
					'id'    => 'custom_tabs',
					'tab'   => esc_html__( 'Tab [5]', 'studiare-plus' ),
					'style' => 'default',
				),
				'class'      => 'xts-col-6',
				'priority'   => 185,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_type_5',
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'type'     => 'buttons',
				'options'  => array(
					'text'       => array(
						'name'  => esc_html__( 'Text', 'studiare-plus' ),
						'value' => 'text',
					),
					'html_block' => array(
						'name'  => esc_html__( 'HTML Block', 'studiare-plus' ),
						'value' => 'html_block',
					),
				),
				'default'  => 'text',
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [5]', 'studiare-plus' ),
				),
				'class'    => 'xts-html-block-switch',
				'priority' => 190,
			)
		);

		$product_metabox->add_field(
			array(
				'id'       => $woodmart_prefix . 'product_custom_tab_content_5',
				'type'     => 'textarea',
				'wysiwyg'  => true,
				'name'     => esc_html__( 'Custom tab content', 'studiare-plus' ),
				'section'  => 'tab_options_section',
				't_tab'    => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [5]', 'studiare-plus' ),
				),
				'requires' => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type_5',
						'compare' => 'equals',
						'value'   => 'text',
					),
				),
				'priority' => 200,
			)
		);

		$product_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_custom_tab_html_block_5',
				'type'         => 'select',
				'section'      => 'tab_options_section',
				'name'         => esc_html__( 'HTML Block', 'studiare-plus' ),
				'select2'      => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'cms_block',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				't_tab'        => array(
					'id'  => 'custom_tabs',
					'tab' => esc_html__( 'Tab [5]', 'studiare-plus' ),
				),
				'requires'     => array(
					array(
						'key'     => $woodmart_prefix . 'product_custom_tab_content_type_5',
						'compare' => 'equals',
						'value'   => 'html_block',
					),
				),
				'priority'     => 210,
			)
		);

		$woodmart_local_transfer_options = array(
			'product_design',
			'single_product_style',
			'thums_position',
			'product-background',
			'main_layout',
			'sidebar_width',
		);

		$woodmart_transfer_options = array_merge( $woodmart_transfer_options, $woodmart_local_transfer_options );
	}

	add_action( 'init', 'woodmart_register_product_metaboxes', 100 );
}


$product_attribute_metabox = Metaboxes::add_metabox(
	array(
		'id'         => 'xts_product_attribute_metaboxes',
		'title'      => esc_html__( 'Extra options from theme', 'studiare-plus' ),
		'object'     => 'term',
		'taxonomies' => array( 'product_cat' ),
	)
);

$product_attribute_metabox->add_section(
	array(
		'id'       => 'general',
		'name'     => esc_html__( 'General', 'studiare-plus' ),
		'icon'     => 'xts-i-footer',
		'priority' => 10,
	)
);

$product_attribute_metabox->add_field(
	array(
		'id'          => 'category_icon_alt',
		'name'        => esc_html__( 'Category icon', 'studiare-plus' ),
		'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'image-for-header-menu.jpg" alt="">', true ),
		'description' => esc_html__( 'This icon will be used in areas such as the header menu, mobile menu, sticky menu, and category search results.', 'studiare-plus' ),
		'type'        => 'upload',
		'section'     => 'general',
		'priority'    => 15,
	)
);

$product_attribute_metabox->add_field(
	array(
		'id'          => 'category_icon',
		'name'        => esc_html__( 'Large category icon', 'studiare-plus' ),
		'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'image-for-categories-navigation.jpg" alt="">', true ),
		'description' => esc_html__( 'This icon will be used in areas such as the category menu in shop the page title and in category elements with the “navigation” type selected.', 'studiare-plus' ),
		'type'        => 'upload',
		'section'     => 'general',
		'priority'    => 20,
	)
);

$product_attribute_metabox->add_field(
	array(
		'id'          => 'title_image',
		'name'        => esc_html__( 'Category page title background', 'studiare-plus' ),
		'hint'        => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'image-for-the-category-page-title.jpg" alt="">', true ),
		'description' => esc_html__( 'This image will be used as the background of the shop page title when viewing this category.', 'studiare-plus' ),
		'type'        => 'upload',
		'section'     => 'general',
		'priority'    => 30,
	)
);

$product_attribute_metabox->add_field(
	array(
		'id'       => 'category_extra_description_type',
		'name'     => esc_html__( 'Extra description', 'studiare-plus' ),
		'hint'     => wp_kses( '<img data-src="' . WOODMART_TOOLTIP_URL . 'category-extra-description.jpg" alt="">', true ),
		'type'     => 'buttons',
		'section'  => 'general',
		'options'  => array(
			'text'       => array(
				'name'  => esc_html__( 'Text', 'studiare-plus' ),
				'value' => 'text',
			),
			'html_block' => array(
				'name'  => esc_html__( 'HTML Block', 'studiare-plus' ),
				'value' => 'html_block',
			),
		),
		'default'  => 'text',
		'priority' => 40,
		'class'    => 'xts-html-block-switch',
	)
);

$product_attribute_metabox->add_field(
	array(
		'id'           => 'category_extra_description_html_block',
		'type'         => 'select',
		'section'      => 'general',
		'name'         => esc_html__( 'HTML Block', 'studiare-plus' ),
		'description'  => esc_html__( 'Additional category description that will be displayed after product loop on this category page.', 'studiare-plus' ),
		'select2'      => true,
		'empty_option' => true,
		'autocomplete' => array(
			'type'   => 'post',
			'value'  => 'cms_block',
			'search' => 'woodmart_get_post_by_query_autocomplete',
			'render' => 'woodmart_get_post_by_ids_autocomplete',
		),
		'requires'     => array(
			array(
				'key'     => 'category_extra_description_type',
				'compare' => 'equals',
				'value'   => 'html_block',
			),
		),
		'priority'     => 50,
	)
);

$product_attribute_metabox->add_field(
	array(
		'id'          => 'category_extra_description_text',
		'name'        => esc_html__( 'Text', 'studiare-plus' ),
		'description' => esc_html__( 'Additional category description that will be displayed after product loop on this category page.', 'studiare-plus' ),
		'type'        => 'textarea',
		'wysiwyg'     => true,
		'section'     => 'general',
		'requires'    => array(
			array(
				'key'     => 'category_extra_description_type',
				'compare' => 'equals',
				'value'   => 'text',
			),
		),
		'priority'    => 50,
	)
);







if ( ! function_exists( 'woodmart_register_expert_metaboxes' ) ) {
	/**
	 * Register page metaboxes
	 *
	 * @since 1.0.0
	 */
	function woodmart_register_expert_metaboxes() {
		global $woodmart_transfer_options, $woodmart_prefix;

		$woodmart_prefix = '_woodmart_';

		$expert_metabox = Metaboxes::add_metabox(
			array(
				'id'         => 'xts_expert_metaboxes',
				'title'      => esc_html__( 'تنظیمات متخصص', 'studiare-plus' ),
				'post_types' => array( 'expert' ),
			)
		);

		$expert_metabox->add_section(
			array(
				'id'       => 'expert_general_section',
				'name'     => esc_html__( 'General', 'studiare-plus' ),
				'icon'     => 'xts-i-cog',
				'priority' => 10,
			)
		);

		$expert_metabox->add_section(
			array(
				'id'       => 'expert_portfolio_section',
				'name'     => esc_html__( 'نمونه کارهای متخصص', 'studiare-plus' ),
				'icon'     => 'xts-i-cog',
				'priority' => 20,
			)
		);

		$expert_metabox->add_section(
			array(
				'id'       => 'expert_contact_section',
				'name'     => esc_html__( 'راه های ارتباطی', 'studiare-plus' ),
				'icon'     => 'xts-i-cog',
				'priority' => 30,
			)
		);



		$expert_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'expert_job',
				'type'        => 'text_input',
				'name'        => esc_html__( 'عنوان شغلی متخصص', 'woodmart' ),
				'section'     => 'expert_general_section',
				'priority'    => 10,
			)
		);


		$expert_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'expert_status',
				'type'        => 'buttons',
				'name'        => esc_html__( 'وضعیت اشتغال متخصص', 'woodmart' ),
				'section'     => 'expert_general_section',
				'options'     => array(
			'is-hired'    => array(
				'name'  => esc_html__( 'استخدام شده', 'studiare-plus' ),
				'value' => 'is-hired',
			),
			'not-hired'  => array(
				'name'  => esc_html__( 'آزاد', 'studiare-plus' ),
				'value' => 'not-hired',
			),
		),
				'default'     => 'not-hired',
				'priority'    => 20,
			)
		);


		$expert_metabox->add_field(
			array(
				'id'           => $woodmart_prefix . 'product_experts',
				'type'         => 'select',
				'section'      => 'expert_general_section',
				'name'         => esc_html__( 'دوره های گذرانده شده متخصص', 'studiare-plus' ),
				'select2'      => true,
				'multiple'    => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type'   => 'post',
					'value'  => 'product',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),
				'class'      => 'xts-col-6',
				'priority'     => 30,
			)
		);


		$expert_metabox->add_field(
			array(
				'id'          => $woodmart_prefix . 'expert_portfolio',
				'type'        => 'upload_list',
				'name'        => esc_html__( 'آپلود نمونه کارهای متخصص', 'studiare-plus' ),
				'section'     => 'expert_portfolio_section',
				'priority'    => 20,
			)
		);


		$expert_metabox->add_field(
			array(
				'id'          => 'expert_tell',
				'type'        => 'text_input',
				'name'        => esc_html__( 'شماره تماس', 'studiare-plus' ),
				'section'     => 'expert_contact_section',
				'priority'    => 10,
			)
		);

		$expert_metabox->add_field(
			array(
				'id'          => 'expert_instagram',
				'type'        => 'text_input',
				'name'        => esc_html__( 'لینک اینستاگرام', 'studiare-plus' ),
				'section'     => 'expert_contact_section',
				'priority'    => 20,
			)
		);

		$expert_metabox->add_field(
			array(
				'id'          => 'expert_telegram',
				'type'        => 'text_input',
				'name'        => esc_html__( 'لینک تلگرام', 'studiare-plus' ),
				'section'     => 'expert_contact_section',
				'priority'    => 30,
			)
		);

		$expert_metabox->add_field(
			array(
				'id'          => 'expert_whatsapp',
				'type'        => 'text_input',
				'name'        => esc_html__( 'شماره ی واتساپ', 'studiare-plus' ),
				'section'     => 'expert_contact_section',
				'priority'    => 40,
			)
		);


	}

	add_action( 'init', 'woodmart_register_expert_metaboxes', 100 );

}






// Studiare Metaboxes
add_action( 'cmb2_admin_init', 'studiare_metaboxes', 200 );


function studiare_metaboxes() {
	// Start with an underscore to hide fields from custom fields list
	$prefix = '_studiare_'; 


	$courses_metaboxes = new_cmb2_box( array(
		'id'            => $prefix . 'courses_metabox',
		'title'         => __( 'تنظیمات دوره(منسوخ شده و برای نسخه قدیمی قالب)', 'cmb2' ),
		'object_types'  => array( 'product' ), // Post type
		'priority'      => 'low',
	) );

    $courses_metaboxes->add_field( array(
        'name' => esc_html__( 'مدرس دوره', 'studiare' ),
        'desc' => esc_html__( 'یک استاد برای این دوره انتخاب کنید', 'studiare' ),
        'id' => $prefix . 'course_teacher',
        'type' => 'select',
        'options' => studiare_get_teachers_list()
    ) );

		$courses_metaboxes->add_field( array(
        'name' => esc_html__( 'مدرس دوم (اختیاری)', 'studiare' ),
        'desc' => esc_html__( 'مدرس دوم را در صورت وجود انتخاب کنید', 'studiare' ),
        'id' => $prefix . 'course_teacher_2',
        'type' => 'select',
        'options' => studiare_get_teachers_list()
    ) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'زبان دوره', 'studiare' ),
		'id'   => $prefix . 'course_language',
		'type' => 'text',
		'default' => ''
	) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'مدت زمان دوره', 'studiare' ),
		'desc' => esc_html__( 'مدت زمان دوره به ساعت', 'studiare' ),
		'default' => '',
		'id'   => $prefix . 'course_duration',
		'type' => 'text',
    ) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'نوع دوره', 'studiare' ),
		'desc' => esc_html__( 'مثلا دروه حضوری است یا غیر حضوری؟', 'studiare' ),
		'default' => '',
		'id'   => $prefix . 'course_type',
		'type' => 'text',
    ) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'پیش نیاز دوره', 'studiare' ),
		'desc' => esc_html__( 'مثلا HTML CSS', 'studiare' ),
		'default' => '',
		'id'   => $prefix . 'course_prerequisite',
		'type' => 'text',
    ) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'تاریخ شروع دوره', 'studiare' ),
		'desc' => esc_html__( 'مثلا: 11 اردیبهشت 1397', 'studiare' ),
		'default' => '',
		'id'   => $prefix . 'course_start_date',
		'type' => 'text',
    ) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'تاریخ بروزرسانی دوره', 'studiare' ),
		'desc' => esc_html__( 'مثلا: 11 اردیبهشت 1397', 'studiare' ),
		'default' => '',
		'id'   => $prefix . 'course_update_date',
		'type' => 'text',
    ) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'حجم کل دوره', 'studiare' ),
		'desc' => esc_html__( 'مثلا: 450 مگابایت', 'studiare' ),
		'default' => '',
		'id'   => $prefix . 'course_file_size',
		'type' => 'text',
    ) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'تعداد دروس دوره', 'studiare' ),
		'desc' => esc_html__( 'تعداد دروسی که دوره شامل می شود.', 'studiare' ),
		'default' => '',
		'id'   => $prefix . 'course_lesseons',
		'type' => 'text',
	) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'روش پشتیبانی', 'studiare' ),
		'desc' => esc_html__( 'مثلا: تلفنی یا ارسال تیکت', 'studiare' ),
		'id'   => $prefix . 'course_support',
		'type' => 'text',
        'default' => ''
	) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'روش دریافت', 'studiare' ),
		'desc' => esc_html__( 'مثلا: دانلود فایل دورس', 'studiare' ),
		'id'   => $prefix . 'course_receive_type',
		'type' => 'text',
        'default' => ''
	) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'گواهینامه دوره', 'studiare' ),
		'id'   => $prefix . 'course_certificate',
		'type' => 'text',
        'default' => ''
	) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'سطح دوره', 'studiare' ),
		'id'   => $prefix . 'course_level',
		'type' => 'text',
        'default' => ''
	) );

	$courses_metaboxes->add_field( array(
		'name' => esc_html__( 'درصد پیشرفت دوره', 'studiare' ),
		'id'   => $prefix . 'course_percent',
		'desc' => esc_html__( 'فقط عدد را بدون علامت درصد وارد کنید.', 'studiare' ),
		'type' => 'text',
        'default' => ''
	) );

	$courses_group_feture = $courses_metaboxes->add_field( array(
		'id'          => 'feture_group',
		'type'        => 'group',
		'description' => __( 'ویژگی های سفارشی دلخواه برای محصول', 'studiare' ),
		'options'     => array(
			'group_title'       => __( 'ویژگی های سفارشی', 'studiare' ),
			'add_button'        => __( 'افزودن ویژگی جدید', 'studiare' ),
			'remove_button'     => __( 'حذف ویژگی', 'studiare' ),
			'sortable'          => true,
		),
	) );

	$courses_metaboxes->add_group_field( $courses_group_feture, array(
		'name' => esc_html__( 'عنوان ویژگی', 'studiare' ),
		'id'   => $prefix . 'feture_title',
		'type' => 'text',
	) );

	$courses_metaboxes->add_group_field( $courses_group_feture, array(
		'name' => esc_html__( 'مقدار روبروی ویژگی', 'studiare' ),
		'id'   => $prefix . 'feture_input',
		'type' => 'text',
	) );




	$studiare_metaboxes_posts = new_cmb2_box( array(
			'id'            => $prefix . 'post_metabox',
			'title'         => __( 'تنظیمات نوشته (منسوخ شده و مربوط به نسخه قدیمی قالب)', 'cmb2' ),
			'object_types'  => array( 'post' ), // Post type
			'vertical_tabs' => false, // Set vertical tabs, default false
	        'tabs' => array(


              array(
	                'id'    => 'tab-2',
	                'icon' => 'dashicons-microphone',
	                'title' => 'تنظمیات نوشته صوتی',
	                'fields' => array(
										$prefix . 'audio_post_id',
	                ),
	            ),

							array(
	                'id'    => 'tab-3',
	                'icon' => 'dashicons-video-alt3',
	                'title' => 'تنظمیات نوشته ویدئویی',
	                'fields' => array(
										$prefix . 'video_post_id',
										$prefix . 'poster_video_post_id',
	                ),
	            ),

							array(
	                'id'    => 'tab-4',
	                'icon' => 'dashicons-download',
	                'title' => 'باکس دانلود نوشته',
	                'fields' => array(

										'studiare_box_title',
										 $prefix . 'download_login',
										 $prefix . 'download_box_content',
										 $prefix . 'download_box_password',
										 'studiare_box_title_2',
										 $prefix . 'link_title_1',
										 $prefix . 'link_url_1',
										 $prefix . 'link_title_2',
										 $prefix . 'link_url_2',
										 $prefix . 'link_title_3',
										 $prefix . 'link_url_3',
										 $prefix . 'link_title_4',
										 $prefix . 'link_url_4',
										 $prefix . 'link_title_5',
										 $prefix . 'link_url_5',
										 'download_group',
										 $prefix . 'download_title_more',
										 $prefix . 'link_download_title_more',

	                ),
	            ),


	        )
		) );



	// Post Metaboxes

	$studiare_metaboxes_posts->add_field( array(
		'name' => esc_html__( 'آپلود فایل ویدئوی شما', 'studiare' ),
		'id'   => $prefix . 'video_post_id',
		'type' => 'file',
		'options' => array(
		'url' => true,
		),
	) );

	$studiare_metaboxes_posts->add_field( array(
		'name' => esc_html__( 'پوستر کاور ویدئو', 'studiare' ),
		'id'   => $prefix . 'poster_video_post_id',
		'type' => 'file',
		'options' => array(
		'url' => true,
		),
	) );

	$studiare_metaboxes_posts->add_field( array(
		'name' => esc_html__( 'آپلود فایل صوتی شما', 'studiare' ),
		'id'   => $prefix . 'audio_post_id',
		'type' => 'file',
		'options' => array(
		'url' => true,
		),
	) );


	// Download Box Metaboxes

  $studiare_metaboxes_posts->add_field( array(
    'name' => 'تنظیمات مربوط به باکس دانلود نوشته',
    'desc' => 'به کمک این بخش می توانید فایل های قابل دانلود نوشته خود را در باکس دانلود درج کنید',
    'type' => 'title',
    'id'   => 'studiare_box_title'
    ) );

		$studiare_metaboxes_posts->add_field( array(
	        'name' => esc_html__( 'محدود کردن مشاهده لینک های دانلود به اعضای وارد شده', 'studiare' ),
	        'desc' => esc_html__( 'اگر این گزینه را تیک بزنید، فقط اعضایی که عضو و وارد حساب کاربری خود شده باشند لینک ها را مشاهده خواهند کرد.', 'studiare' ),
	        'id'   => $prefix . 'download_login',
	        'type' => 'checkbox',
	        'default' => ''
	    ) );


  $studiare_metaboxes_posts->add_field( array(
  		'name' => esc_html__( 'محل وارد کردن متن دلخواه شما برای باکس دانلود', 'studiare' ),
  		'desc' => esc_html__( '', 'studiare' ),
  		'id'   => $prefix . 'download_box_content',
  		'type' => 'wysiwyg',
  	) );

    $studiare_metaboxes_posts->add_field( array(
        'name' => esc_html__( 'پسورد فایل های زیپ', 'studiare' ),
        'desc' => esc_html__( 'اگر پسورد ندارد بنویسید : ندارد', 'studiare' ),
        'id'   => $prefix . 'download_box_password',
        'type' => 'text',
      ) );

  $studiare_metaboxes_posts->add_field( array(
      'name' => 'لینک های دانلود',
      'desc' => 'لینک های دانلود خود را در فیلد های زیر وارد کنید',
      'type' => 'title',
      'id'   => 'studiare_box_title_2'
      ) );

  $studiare_metaboxes_posts->add_field( array(
      'name' => esc_html__( 'عنوان لینک اول', 'studiare' ),
      'desc' => esc_html__( '', 'studiare' ),
      'id'   => $prefix . 'link_title_1',
      'type' => 'text',
    ) );

  $studiare_metaboxes_posts->add_field( array(
        'name' => esc_html__( 'نشانی لینک اول', 'studiare' ),
        'desc' => esc_html__( '', 'studiare' ),
        'id'   => $prefix . 'link_url_1',
        'type' => 'text_url',
    ) );

    $studiare_metaboxes_posts->add_field( array(
        'name' => esc_html__( 'عنوان لینک دوم', 'studiare' ),
        'desc' => esc_html__( '', 'studiare' ),
        'id'   => $prefix . 'link_title_2',
        'type' => 'text',
      ) );

    $studiare_metaboxes_posts->add_field( array(
          'name' => esc_html__( 'نشانی لینک دوم', 'studiare' ),
          'desc' => esc_html__( '', 'studiare' ),
          'id'   => $prefix . 'link_url_2',
          'type' => 'text_url',
      ) );
    $studiare_metaboxes_posts->add_field( array(
          'name' => esc_html__( 'عنوان لینک سوم', 'studiare' ),
          'desc' => esc_html__( '', 'studiare' ),
          'id'   => $prefix . 'link_title_3',
          'type' => 'text',
        ) );

    $studiare_metaboxes_posts->add_field( array(
            'name' => esc_html__( 'نشانی لینک سوم', 'studiare' ),
            'desc' => esc_html__( '', 'studiare' ),
            'id'   => $prefix . 'link_url_3',
            'type' => 'text_url',
        ) );

		$studiare_metaboxes_posts->add_field( array(
		          'name' => esc_html__( 'عنوان لینک چهارم', 'studiare' ),
		          'desc' => esc_html__( '', 'studiare' ),
		          'id'   => $prefix . 'link_title_4',
		          'type' => 'text',
		        ) );

		$studiare_metaboxes_posts->add_field( array(
		            'name' => esc_html__( 'نشانی لینک چهارم', 'studiare' ),
		            'desc' => esc_html__( '', 'studiare' ),
		            'id'   => $prefix . 'link_url_4',
		            'type' => 'text_url',
		 ) );

		 $studiare_metaboxes_posts->add_field( array(
		 			'name' => esc_html__( 'عنوان لینک پنجم', 'studiare' ),
		 			'desc' => esc_html__( '', 'studiare' ),
		 			'id'   => $prefix . 'link_title_5',
		 			'type' => 'text',
		 		) );

		 $studiare_metaboxes_posts->add_field( array(
		 				'name' => esc_html__( 'نشانی لینک پنجم', 'gigafile' ),
		 				'desc' => esc_html__( '', 'gigafile' ),
		 				'id'   => $prefix . 'link_url_5',
		 				'type' => 'text_url',
		 		) );

				$studiare_group_downloads = $studiare_metaboxes_posts->add_field( array(
						'id'          => 'download_group',
						'type'        => 'group',
						'description' => __( 'برای اضافه کردن لینک دانلود بیشتر', 'studiare' ),
						'options'     => array(
							'group_title'       => __( 'لینک دانلود', 'studiare' ),
							'add_button'        => __( 'اضافه کردن لینک دانلود دیگر', 'studiare' ),
							'remove_button'     => __( 'حذف لینک دانلود', 'studiare' ),
							'sortable'          => false,
						),
				) );

		$studiare_metaboxes_posts->add_group_field( $studiare_group_downloads, array(
			'name' => esc_html__( 'عنوان لینک', 'studiare' ),
			'id'   => $prefix . 'download_title_more',
			'type' => 'text',
		) );

		$studiare_metaboxes_posts->add_group_field( $studiare_group_downloads, array(
			'name' => esc_html__( 'نشانی لینک', 'studiare' ),
			'id'   => $prefix . 'link_download_title_more',
			'type' => 'text_url',
   	) );


}