<?php
/**
 * Product metaboxes
 *
 * @package xts
 */

if (!defined('ABSPATH')) {
	exit; // Direct access not allowed.
}

use XTS\Admin\Modules\Options\Metaboxes;



if (!function_exists('studiare_register_post_metaboxes')) {
	/**
	 * Register page metaboxes
	 *
	 * @since 1.0.0
	 */
	function studiare_register_post_metaboxes()
	{
		global $woodmart_transfer_options, $woodmart_prefix;

		$woodmart_prefix = '_woodmart_';

		$post_metabox = Metaboxes::add_metabox(
			array(
				'id' => 'xts_posts_metaboxes',
				'title' => esc_html__('تنظیمات نوشته', 'studiare-plus'),
				'post_types' => array('post'),
			)
		);

		$post_metabox->add_section(
			array(
				'id' => 'post_video_section',
				'name' => esc_html__('فرمت ویدئو', 'studiare-plus'),
				'icon' => 'xts-i-cog',
				'priority' => 10,
			)
		);

		$post_metabox->add_section(
			array(
				'id' => 'post_audio_section',
				'name' => esc_html__('فرمت صوتی', 'studiare-plus'),
				'icon' => 'xts-i-phone',
				'priority' => 20,
			)
		);



		$post_metabox->add_field(
			array(
				'id' => $woodmart_prefix . 'video_link_url',
				'type' => 'text_input',
				'name' => esc_html__('لینک مستقیم فایل mp4', 'woodmart'),
				'section' => 'post_video_section',
				'requires' => array(
					array(
						'key' => '_woodmart_video_type',
						'compare' => 'equals',
						'value' => 'external-link',
					),
				),
				'priority' => 10,

			)
		);


		$post_metabox->add_field(
			array(
				'id' => $woodmart_prefix . 'video_cover',
				'type' => 'upload',
				'name' => esc_html__('آپلود تصویر کاور ویدئو', 'woodmart'),
				'section' => 'post_video_section',
				'priority' => 50,

			)
		);



		$post_metabox->add_field(
			array(
				'id' => $woodmart_prefix . 'audio_file_mp3',
				'type' => 'text_input',
				'section' => 'post_audio_section',
				'name' => esc_html__('لینک مستقیم mp3', 'studiare-plus'),

				'priority' => 10,
			)
		);


	}

	add_action('init', 'studiare_register_post_metaboxes', 100);

}
















if (!function_exists('woodmart_register_post_metaboxes')) {
	/**
	 * Register page metaboxes
	 *
	 * @since 1.0.0
	 */
	function woodmart_register_post_metaboxes()
	{
		global $woodmart_transfer_options, $woodmart_prefix;

		$woodmart_prefix = '_woodmart_';

		$teacher_metabox = Metaboxes::add_metabox(
			array(
				'id' => 'xts_teacher_metaboxes',
				'title' => esc_html__('تنظیمات مدرس', 'studiare-plus'),
				'post_types' => array('teacher'),
			)
		);

		$teacher_metabox->add_section(
			array(
				'id' => 'teacher_general_section',
				'name' => esc_html__('General', 'studiare-plus'),
				'icon' => 'xts-i-cog',
				'priority' => 10,
			)
		);

		$teacher_metabox->add_section(
			array(
				'id' => 'teacher_contact_section',
				'name' => esc_html__('راه های ارتباطی', 'studiare-plus'),
				'icon' => 'xts-i-phone',
				'priority' => 20,
			)
		);

		$teacher_metabox->add_field(
			array(
				'id' => $woodmart_prefix . 'teacher_second_title',
				'type' => 'text_input',
				'name' => esc_html__('عنوان معرفی یا لقب مدرس', 'woodmart'),
				'section' => 'teacher_general_section',
				'priority' => 10,

			)
		);

		$teacher_metabox->add_field(
			array(
				'id' => $woodmart_prefix . 'teacher_medals',
				'type' => 'select',
				'section' => 'teacher_general_section',
				'name' => esc_html__('مدال های مدرس', 'studiare-plus'),
				'select2' => true,
				'multiple' => true,
				'empty_option' => true,
				'autocomplete' => array(
					'type' => 'post',
					'value' => 'cms_medal',
					'search' => 'woodmart_get_post_by_query_autocomplete',
					'render' => 'woodmart_get_post_by_ids_autocomplete',
				),

				'priority' => 30,
			)
		);



		$teacher_metabox->add_field(
			array(
				'id' => 'expert_tell',
				'type' => 'text_input',
				'name' => esc_html__('شماره تماس', 'studiare-plus'),
				'section' => 'teacher_contact_section',
				'priority' => 10,
				'class' => 'xts-col-6',
			)
		);

		$teacher_metabox->add_field(
			array(
				'id' => 'expert_instagram',
				'type' => 'text_input',
				'name' => esc_html__('لینک اینستاگرام', 'studiare-plus'),
				'section' => 'teacher_contact_section',
				'priority' => 20,
				'class' => 'xts-col-6',
			)
		);

		$teacher_metabox->add_field(
			array(
				'id' => 'expert_telegram',
				'type' => 'text_input',
				'name' => esc_html__('لینک تلگرام', 'studiare-plus'),
				'section' => 'teacher_contact_section',
				'priority' => 30,
				'class' => 'xts-col-6',
			)
		);

		$teacher_metabox->add_field(
			array(
				'id' => 'expert_whatsapp',
				'type' => 'text_input',
				'name' => esc_html__('شماره ی واتساپ', 'studiare-plus'),
				'section' => 'teacher_contact_section',
				'priority' => 40,
				'class' => 'xts-col-6',
			)
		);

	}

	add_action('init', 'woodmart_register_post_metaboxes', 100);

}





