<?php

/* Template name: Experts */
get_header(); ?>

<div class="expert-archive-wrap">

    <!-- سایدبار فیلتر -->
    <aside id="expert-sidebar" class="expert-sidebar">
        <form id="expert-filter-form">
            <?php
            $taxonomies = array('expert_skill', 'expert_location', 'expert_salary', 'expert_contract');
            foreach ($taxonomies as $taxonomy):
                $terms = get_terms(array('taxonomy' => $taxonomy, 'hide_empty' => true));
                if (!empty($terms)): ?>
                    <div class="filter-group">
                        <h5 class="expert-filter-title"><?php echo esc_html(get_taxonomy($taxonomy)->label); ?></h5>
                        <?php foreach ($terms as $term): ?>
                            <div>
                                <label>
                                    <input type="checkbox" name="<?php echo esc_attr($taxonomy) ?>[]"
                                        value="<?php echo esc_attr($term->slug) ?>">
                                    <?php echo esc_html($term->name) ?>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif;
            endforeach; ?>
        </form>
    </aside>
    <div id="expert-sidebar-backdrop" class="expert-sidebar-backdrop"></div>

    <!-- لیست متخصص‌ها -->
    <div class="expert-list">
        <div class="ads-archive-header-holder">
						<div class="ads-archive-header-inner">
							<h2 class="ads-archive-header-title">
								<span>تمام متخصص‌های ما</span>
							</h2>
							<div class="ads-archive-header-count"><span><?php $count_experts = wp_count_posts( 'expert' )->publish; echo $count_experts; ?> متخصص</span></div>
						</div>
						<div class="ads-archive-header-fitlers">
                            <button id="expert-filter-toggle" class="expert-filter-toggle"><i class="fal fa-sliders"></i><span>فیلترها</span></button>
						</div>
                        
		</div>

                    
        <div id="expert-results" class="experts-grid">
            <?php
            $args = array(
                'post_type' => 'expert',
                'posts_per_page' => 10,
            );
            $loop = new WP_Query($args);
            if ($loop->have_posts()):
                while ($loop->have_posts()):
                    $loop->the_post();
                    echo '<div class="expert-card-holder">';
                    get_template_part('content', 'expert');
                    echo '</div>';
                endwhile;
            endif;
            wp_reset_postdata();
            ?>
        </div>

        <!-- پیام هیچ متخصصی یافت نشد -->
        <div id="expert-no-results" style="display:none; text-align:center; margin-top:20px;">
            <p>هیچ متخصصی یافت نشد.</p>
        </div>

        <!-- لودینگ -->
        <div id="expert-loading" style="display:none; text-align:center; margin-top:20px;">
            <p>در حال بارگذاری...</p>
        </div>
    </div>

</div>

<?php get_footer(); ?>