<?php
$job_title = get_post_meta(get_the_ID(), '_woodmart_expert_job', true);
$status = get_post_meta(get_the_ID(), '_woodmart_expert_status', true);

$portfolio_raw = get_post_meta(get_the_ID(), '_woodmart_expert_portfolio', true);
$portfolio = [];

if (!empty($portfolio_raw)) {
    $portfolio = array_filter(array_map('trim', explode(',', $portfolio_raw)));
}
?>

<div class="expert-card <?php echo esc_attr($status); ?>">

    <div class="experts-list-item-header">
        <?php if (has_post_thumbnail()): ?>
                <?php the_post_thumbnail('thumbnail'); ?>
        <?php endif; ?>

        <div class="experts-list-item-name-holder">
            <a href="<?php the_permalink(); ?>" class="experts-list-item">
                <h5 class="experts-list-item-name"><?php the_title(); ?></h5>
            </a>
            <h4 class="experts-list-item-title"><?php echo esc_html($job_title); ?></h4>
        </div>
        <?php
        // اگر استخدام شده بود نمایش بده
        if ($status === 'is-hired'): ?>
        <div class="experts-list-item-hired">
            <i class="fal fa-check"></i>
            <span>استخدام شده</span>
        </div>
<?php endif; ?>

    </div>

    <?php
    // خواندن متا نمونه‌کار
    $portfolio = get_post_meta(get_the_ID(), '_woodmart_expert_portfolio', true);

    // اگر رشته بود تبدیل به آرایه
    if (!empty($portfolio) && !is_array($portfolio)) {
        $portfolio = array_map('trim', explode(',', $portfolio));
    }

    // آیا نمونه کار معتبر داریم؟
    $has_portfolio = !empty($portfolio) && is_array($portfolio) && count($portfolio) > 0;
    ?>

<?php if ($has_portfolio): ?>

        <!-- نمایش فقط نمونه‌کار -->
        <div class="experts-list-portfolio-holder">
            <div class="experts-list-gallery">
                <?php foreach ($portfolio as $image):

                    // تشخیص ID یا URL
                    $thumb = is_numeric($image)
                        ? wp_get_attachment_image_url($image, 'thumbnail')
                        : $image;

                    if (empty($thumb))
                        continue;
                    ?>
                        <div class="experts-list-gallery-item">
                            <div class="experts-list-gallery-item-inner">
                                <img alt="" src="<?php echo esc_url($thumb); ?>">
                            </div>
                        </div>
                <?php endforeach; ?>
            </div>
        </div>

<?php else: ?>

        <!-- اگر نمونه کار نبود، مهارت‌ها را نمایش بده -->
        <div class="experts-list-item-skills-holder">
            <span class="experts-skills-title">مهارت‌ها</span>
            <div class="experts-list-item-skills">
                <?php
                $terms = get_the_terms(get_the_ID(), 'expert_skill');
                if ($terms && !is_wp_error($terms)) {
                    foreach ($terms as $term) {
                        echo '<span claوss="expert-skill">' . esc_html($term->name) . '</span>';
                    }
                }
                ?>
            </div>
        </div>

<?php endif; ?>


    <div class="experts-list-item-footer">

        <div class="experts-list-item-info">

            <div class="experts-list-item-location">
                <i class="fal fa-location-dot"></i>
                <?php
                $terms = get_the_terms(get_the_ID(), 'expert_location');
                if ($terms && !is_wp_error($terms)) {
                    foreach ($terms as $term) {
                        echo '<span class="expert-location">' . esc_html($term->name) . '</span> ';
                    }
                }
                ?>
            </div>

            <div class="experts-list-item-contract">
                <?php
                $terms = get_the_terms(get_the_ID(), 'expert_contract');
                if ($terms && !is_wp_error($terms)) {
                    foreach ($terms as $term) {
                        echo '<span class="expert-contract">' . esc_html($term->name) . '</span> ';
                    }
                }
                ?>
            </div>
        </div>

        <div class="experts-list-item-salary">
            <?php
            $terms = get_the_terms(get_the_ID(), 'expert_salary');
            if ($terms && !is_wp_error($terms)) {
                foreach ($terms as $term) {
                    echo '<span class="expert-salary">' . esc_html($term->name) . '</span> ';
                }
            }
            ?>
        </div>

    </div>
</div>
