<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// search
class studiare_Widget_Accordion extends Widget_Base {

   public function get_name() {
      return 'accordion';
   }

   public function get_title() {
      return esc_html__( 'آکاردئون', 'studiare-plus' );
   }

   public function get_icon() {
        return 'eicon-accordion';
   }

   public function get_categories() {
      return [ 'studiare-elements' ];
   }

   protected function register_controls() {

	$this->start_controls_section(
		'general_content_section',
		array(
			'label' => esc_html__( 'عمومی', 'studiare-plus' ),
		)
	);

	$repeater = new Repeater();

	$repeater->start_controls_tabs( 'accordion_items' );

	$repeater->start_controls_tab(
		'content_tab',
		array(
			'label' => esc_html__( 'محتوا', 'studiare-plus' ),
			'tab'   => Controls_Manager::TAB_CONTENT,
		)
	);

	$repeater->add_control(
		'item_title',
		array(
			'label'   => esc_html__( 'عنوان', 'studiare-plus' ),
			'type'    => Controls_Manager::TEXT,
			'default' => 'عنوان آکاردئون. برای ویرایش اینجا کلیک کنید.',
		)
	);

	$repeater->add_control(
		'item_content',
		array(
			'label'     => esc_html__( 'محتوا', 'studiare-plus' ),
			'type'      => Controls_Manager::WYSIWYG,
			'default'   => '<i>برای تغییر متن اینجا کلیک کنید</i>.لورم ایپسوم متن ساختگی....',
		)
	);

	$repeater->end_controls_tab();
	$repeater->end_controls_tabs();

	$this->add_control(
		'items',
		array(
			'type'        => Controls_Manager::REPEATER,
			'title_field' => '{{{ item_title }}}',
			'fields'      => $repeater->get_controls(),
			'default'     => array(
				array(
					'item_title'   => 'عنوان آکاردئون',
					'item_content' => 'لورم ایپسوم متن ساختگی....',
				),
				array(
					'item_title'   => 'عنوان آکاردئون',
					'item_content' => 'لورم ایپسوم متن ساختگی....',
				),
				array(
					'item_title'   => 'عنوان آکاردئون',
					'item_content' => 'لورم ایپسوم متن ساختگی....',
				),
			),
		)
	);

	$this->end_controls_section();


	/**
		 * Style tab
		 */

		/**
		 * General settings
		 */
		$this->start_controls_section(
			'general_style_section',
			array(
				'label' => esc_html__( 'عمومی', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'state',
			array(
				'label'   => esc_html__( 'وضعیت آیتم ها', 'studiare-plus' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'first'      => esc_html__( 'اولی باز باشد', 'studiare-plus' ),
					'all_closed' => esc_html__( 'همه بسته باشند', 'studiare-plus' ),
				),
				'default' => 'first',
			)
		);

		$this->add_control(
			'title_text_alignment',
			array(
				'label'   => esc_html__( 'تراز متن عنوان', 'studiare-plus' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'left'  => array(
						'title' => esc_html__( 'چپ', 'studiare-plus' ),
					),
					'right' => array(
						'title' => esc_html__( 'راست', 'studiare-plus' ),
					),
				),
				'default' => 'right',
			)
		);

		$this->end_controls_section();



		/**
		 * Title settings
		 */
		$this->start_controls_section(
			'title_style_section',
			array(
				'label' => esc_html__( 'عنوان', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'studiare-plus' ),
				'selector' => '{{WRAPPER}} .wd-accordion-title-text',
			)
		);

	
		$this->end_controls_section();


		/**
		 * Content settings
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'محتوا', 'studiare-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'content_custom_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'studiare-plus' ),
				'selector' => '{{WRAPPER}} .wd-accordion-content',
			)
		);

		$this->end_controls_section();




		

   }


   protected function render( $instance = [] ) {

	$default_settings = array(
		/**
		 * General Settings.
		 */
		'style'                     => 'default',
		'state'                     => 'first',

	);

    // get our input from the widget settings.
    $settings = $this->get_settings_for_display(); ?>


<div class="wd-accordion wd-style-shadow" data-state="<?php echo esc_attr( $settings['state'] ); ?>">
			<?php foreach ( $settings['items'] as $index => $item ) : ?>
				<?php
				$content_setting_key = $this->get_repeater_setting_key( 'item_content', 'items', $index );

				$this->add_inline_editing_attributes( $content_setting_key );

				$title_classes_wrapper  = ' text-' . $settings['title_text_alignment'];
				$content_classes = '';
				$title_classes = ' ';

				$loop_title_classes_wrapper   = '';
				$loop_content_classes_wrapper = '';

				if ( 0 === $index && 'first' === $settings['state'] ) {
					$loop_title_classes_wrapper   .= ' wd-active';
					$loop_content_classes_wrapper .= ' wd-active';
				}

				$loop_title_classes_wrapper   .= $title_classes_wrapper;
				$loop_content_classes_wrapper .= $content_classes;

				?>

				<div class="wd-accordion-item">
					<div class="wd-accordion-title<?php echo esc_attr( $loop_title_classes_wrapper ); ?>" data-accordion-index="<?php echo esc_attr( $index ); ?>">
						<div class="wd-accordion-title-text">
							<span>
								<?php echo esc_html( $item['item_title'] ); ?>
							</span>
						</div>
						<span class="wd-accordion-opener wd-opener-style-arrow"></span>
					</div>

					<div class="wd-accordion-content reset-last-child<?php echo esc_attr( $loop_content_classes_wrapper ); ?>" data-accordion-index="<?php echo esc_attr( $index ); ?>">
						<?php echo do_shortcode( $item['item_content'] ); ?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>



      <?php
   }
}

Plugin::instance()->widgets_manager->register( new studiare_Widget_Accordion );
