<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class WOODMART_Post_Types {
	public $domain = 'woodmart_starter';

	protected static $_instance = null;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function __clone() {
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'studiare-plus' ), '2.1' );
	}

	public function __wakeup() {
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'studiare-plus' ), '2.1' );
	}

	public function __construct() {

		// Hook into the 'init' action
		add_action( 'init', array( $this, 'register_blocks' ), 1 );
		add_action( 'init', array( $this, 'register_lessons' ), 1 );
		add_action( 'init', array( $this, 'register_medals' ), 1 );
		add_action( 'init', array( $this, 'size_guide' ), 1 );
		add_action( 'init', array( $this, 'slider' ), 1 );

		// Duplicate post action for slides
		add_filter( 'post_row_actions', array( $this, 'duplicate_action' ), 10, 2 );
		add_filter( 'admin_action_woodmart_duplicate_post_as_draft', array( $this, 'duplicate_post_as_draft' ), 10, 2 );

		// Manage slides list columns
		add_filter( 'manage_edit-woodmart_slide_columns', array( $this, 'edit_woodmart_slide_columns' ) );
		add_action( 'manage_woodmart_slide_posts_custom_column', array( $this, 'manage_woodmart_slide_columns' ), 10, 2 );

		// Add shortcode column to block list
		add_filter( 'manage_edit-cms_block_columns', array( $this, 'edit_html_blocks_columns' ) );
		add_action( 'manage_cms_block_posts_custom_column', array( $this, 'manage_html_blocks_columns' ), 10, 2 );


		// Add shortcode column to lesson list
		add_filter( 'manage_edit-cms_lesson_columns', array( $this, 'edit_html_lessons_columns' ) );
		add_action( 'manage_cms_lesson_posts_custom_column', array( $this, 'manage_html_lessons_columns' ), 10, 2 );

		add_filter( 'manage_edit-portfolio_columns', array( $this, 'edit_portfolio_columns' ) );
		add_action( 'manage_portfolio_posts_custom_column', array( $this, 'manage_portfolio_columns' ), 10, 2 );

		add_action( 'init', array( $this, 'register_sidebars' ), 1 );
		add_action( 'init', array( $this, 'slider' ), 1 );
		add_action( 'init', array( $this, 'register_portfolio' ), 1 );
	}

	// **********************************************************************//
	// ! Register Custom Post Type for WoodMart slider
	// **********************************************************************//
	public function slider() {
		if ( function_exists( 'woodmart_get_opt' ) && ! woodmart_get_opt( 'woodmart_slider', '1' ) ) {
			return;
		}

		$labels = array(
			'name'               => esc_html__( 'Slides', 'studiare-plus' ),
			'singular_name'      => esc_html__( 'Slide', 'studiare-plus' ),
			'menu_name'          => esc_html__( 'Slides', 'studiare-plus' ),
			'all_items'     => esc_html__( 'All Slides', 'studiare-plus' ),
			'add_new'       => esc_html__( 'Add Slide', 'studiare-plus' ),
			'add_new_item'  => esc_html__( 'Add Slide', 'studiare-plus' ),
		);

		$args = array(
			'label'               => 'woodmart_slide',
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'thumbnail', 'page-attributes', 'custom-fields' ),
			'hierarchical'        => false,
			'public'              => true,
			'publicly_queryable'  => is_user_logged_in(),
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'menu_position'       => 32,
			'menu_icon'           => 'dashicons-images-alt2',
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'capability_type'     => 'page',
		);

		register_post_type( 'woodmart_slide', $args );

		$labels = array(
			'name'                  => esc_html__( 'Sliders', 'studiare-plus' ),
			'singular_name'         => esc_html__( 'Slider', 'studiare-plus' ),
			'search_items'          => esc_html__( 'Search Sliders', 'studiare-plus' ),
			'popular_items'         => esc_html__( 'Popular Sliders', 'studiare-plus' ),
			'all_items'             => esc_html__( 'All Sliders', 'studiare-plus' ),
			'parent_item'           => esc_html__( 'Parent Slider', 'studiare-plus' ),
			'parent_item_colon'     => esc_html__( 'Parent Slider', 'studiare-plus' ),
			'edit_item'             => esc_html__( 'Edit Slider', 'studiare-plus' ),
			'update_item'           => esc_html__( 'Update Slider', 'studiare-plus' ),
			'add_new_item'          => esc_html__( 'Add New Slider', 'studiare-plus' ),
			'new_item_name'         => esc_html__( 'New Slide', 'studiare-plus' ),
			'add_or_remove_items'   => esc_html__( 'Add or remove Sliders', 'studiare-plus' ),
			'choose_from_most_used' => esc_html__( 'Choose from most used sliders', 'studiare-plus' ),
			'menu_name'             => esc_html__( 'Sliders', 'studiare-plus' ),
		);

		$args = array(
			'labels'             => $labels,
			'public'             => true,
			'show_in_nav_menus'  => false,
			'show_admin_column'  => false,
			'hierarchical'       => true,
			'show_tagcloud'      => false,
			'show_ui'            => true,
			'query_var'          => false,
			'publicly_queryable' => false,
			'rewrite'            => array( 'slug' => 'woodmart_slider' ),
			'capabilities'       => array(),
		);

		register_taxonomy( 'woodmart_slider', array( 'woodmart_slide' ), $args );
	}

	public function duplicate_action( $actions, $post ) {
		if ( ! in_array( $post->post_type, array( 'woodmart_slide', 'cms_block', 'cms_lesson', 'wd_popup', 'wd_floating_block' ), true )  ) {
			return $actions;
		}

		if ( current_user_can( 'edit_posts' ) ) {
			$actions['duplicate'] = '<a href="' . wp_nonce_url( 'admin.php?action=woodmart_duplicate_post_as_draft&post=' . $post->ID, 'woodmart_duplicate_post_as_draft', 'duplicate_nonce' ) . '" title="Duplicate this item" rel="permalink">Duplicate</a>';
		}
		return $actions;
	}

	public function duplicate_post_as_draft() {
		global $wpdb;
		if ( ! ( isset( $_GET['post'] ) || isset( $_POST['post'] ) || ( isset( $_REQUEST['action'] ) && 'woodmart_duplicate_post_as_draft' == $_REQUEST['action'] ) ) ) {
			wp_die( 'No post to duplicate has been supplied!' );
		}

		/*
		 * Nonce verification
		 */
		if ( ! isset( $_GET['duplicate_nonce'] ) || ! wp_verify_nonce( $_GET['duplicate_nonce'], 'woodmart_duplicate_post_as_draft' ) ) {
			return;
		}

		/*
		 * get the original post id
		 */
		$post_id = ( isset( $_GET['post'] ) ? absint( $_GET['post'] ) : absint( $_POST['post'] ) );
		/*
		 * and all the original post data then
		 */
		$post = get_post( $post_id );

		/*
		 * if you don't want current user to be the new post author,
		 * then change next couple of lines to this: $new_post_author = $post->post_author;
		 */
		$current_user    = wp_get_current_user();
		$new_post_author = $current_user->ID;

		/*
		 * if post data exists, create the post duplicate
		 */
		if ( isset( $post ) && $post != null ) {
			$post_content = $post->post_content;

			if ( has_blocks( $post_content ) ) {
				$post_content = wp_slash( $post_content );
			}

			/*
			 * new post data array
			 */
			$args = array(
				'comment_status' => $post->comment_status,
				'ping_status'    => $post->ping_status,
				'post_author'    => $new_post_author,
				'post_content'   => $post_content,
				'post_excerpt'   => $post->post_excerpt,
				'post_name'      => $post->post_name,
				'post_parent'    => $post->post_parent,
				'post_password'  => $post->post_password,
				'post_status'    => 'draft',
				'post_title'     => $post->post_title . ' (duplicate)',
				'post_type'      => $post->post_type,
				'to_ping'        => $post->to_ping,
				'menu_order'     => $post->menu_order,
			);

			/*
			 * insert the post by wp_insert_post() function
			 */
			$new_post_id = wp_insert_post( $args );

			/*
			 * get all current post terms ad set them to the new post draft
			 */
			$taxonomies = get_object_taxonomies( $post->post_type ); // returns array of taxonomy names for post type, ex array("category", "post_tag");
			foreach ( $taxonomies as $taxonomy ) {
				$post_terms = wp_get_object_terms( $post_id, $taxonomy, array( 'fields' => 'slugs' ) );
				wp_set_object_terms( $new_post_id, $post_terms, $taxonomy, false );
			}

			/*
			 * duplicate all post meta just in two SQL queries
			 */
			$post_meta_infos = $wpdb->get_results( "SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=$post_id" );
			if ( count( $post_meta_infos ) != 0 ) {
				$sql_query = "INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) ";
				foreach ( $post_meta_infos as $meta_info ) {
					$meta_key = $meta_info->meta_key;
					if ( $meta_key == '_wp_old_slug' ) {
						continue;
					}
					$meta_value      = addslashes( $meta_info->meta_value );
					$sql_query_sel[] = "SELECT $new_post_id, '$meta_key', '$meta_value'";
				}
				$sql_query .= implode( ' UNION ALL ', $sql_query_sel );
				$wpdb->query( $sql_query );
			}

			/*
			 * finally, redirect to the edit post screen for the new draft
			 */
			wp_redirect( admin_url( 'post.php?action=edit&post=' . $new_post_id ) );
			exit;
		} else {
			wp_die( 'Post creation failed, could not find original post: ' . $post_id );
		}
	}

	// **********************************************************************//
	// ! Register Custom Post Type for Size Guide
	// **********************************************************************//
	public function size_guide() {

		if ( function_exists( 'woodmart_get_opt' ) && ! woodmart_get_opt( 'size_guides', '1' ) ) {
			return;
		}

		$labels = array(
			'name'          => esc_html__( 'Size Guides', 'studiare-plus' ),
			'singular_name' => esc_html__( 'Size Guide', 'studiare-plus' ),
			'menu_name'     => esc_html__( 'Size Guides', 'studiare-plus' ),
		);

		$args = array(
			'label'               => esc_html__( 'woodmart_size_guide', 'studiare-plus' ),
			'description'         => esc_html__( 'Size guide to place in your products', 'studiare-plus' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor' ),
			'hierarchical'        => false,
			'public'              => false,
			'show_ui'             => true,
			'show_in_menu'        => 'edit.php?post_type=product',
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'menu_icon'           => 'dashicons-editor-kitchensink',
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'rewrite'             => false,
			'show_in_rest'        => true,
			'capability_type'     => 'product',
		);

		register_post_type( 'woodmart_size_guide', $args );
	}

	// **********************************************************************//
	// ! Register Custom Post Type for HTML Blocks
	// **********************************************************************//

	public function register_blocks() {

		$labels = array(
			'name'          => esc_html__( 'HTML Blocks', 'studiare-plus' ),
			'singular_name' => esc_html__( 'HTML Block', 'studiare-plus' ),
			'menu_name'     => esc_html__( 'HTML Blocks', 'studiare-plus' ),
			'all_items'     => esc_html__( 'All Blocks', 'studiare-plus' ),
			'add_new'       => esc_html__( 'Add Block', 'studiare-plus' ),
			'add_new_item'  => esc_html__( 'Add Block', 'studiare-plus' ),
		);

		$args = array(
			'label'               => esc_html__( 'cms_block', 'studiare-plus' ),
			'description'         => esc_html__( 'CMS Blocks for custom HTML to place in your pages', 'studiare-plus' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor' ),
			'hierarchical'        => false,
			'public'              => true,
			'publicly_queryable'  => is_user_logged_in(),
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'menu_position'       => 32,
			'menu_icon'           => 'dashicons-schedule',
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'rewrite'             => false,
			'capability_type'     => 'page',
			'show_in_rest'        => true,
		);

		register_post_type( 'cms_block', $args );

		$labels = array(
			'name'                  => esc_html__( 'HTML Block categories', 'studiare-plus' ),
			'singular_name'         => esc_html__( 'HTML Block category', 'studiare-plus' ),
			'search_items'          => esc_html__( 'Search categories', 'studiare-plus' ),
			'popular_items'         => esc_html__( 'Popular categories', 'studiare-plus' ),
			'all_items'             => esc_html__( 'All categories', 'studiare-plus' ),
			'parent_item'           => esc_html__( 'Parent category', 'studiare-plus' ),
			'parent_item_colon'     => esc_html__( 'Parent category', 'studiare-plus' ),
			'edit_item'             => esc_html__( 'Edit category', 'studiare-plus' ),
			'update_item'           => esc_html__( 'Update category', 'studiare-plus' ),
			'add_new_item'          => esc_html__( 'Add New category', 'studiare-plus' ),
			'new_item_name'         => esc_html__( 'New category', 'studiare-plus' ),
			'add_or_remove_items'   => esc_html__( 'Add or remove categories', 'studiare-plus' ),
			'choose_from_most_used' => esc_html__( 'Choose from most used', 'studiare-plus' ),
			'menu_name'             => esc_html__( 'Categories', 'studiare-plus' ),
		);

		$args = array(
			'labels'            => $labels,
			'public'            => true,
			'show_in_nav_menus' => false,
			'show_admin_column' => false,
			'hierarchical'      => true,
			'show_tagcloud'     => true,
			'show_ui'           => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'cms_block_cat' ),
			'capabilities'      => array(),
			'default_term'      => array(
				'name' => esc_html__( 'Uncategorized', 'studiare-plus' ),
				'slug' => 'uncategorized',
			),
			'show_in_rest'      => true,
		);

		register_taxonomy( 'cms_block_cat', array( 'cms_block' ), $args );
	}


	public function edit_html_blocks_columns( $columns ) {
		unset( $columns['date'] );

		$new_columns = array(
			'shortcode'     => esc_html__( 'Shortcode', 'studiare-plus' ),
			'wd_categories' => esc_html__( 'Categories', 'studiare-plus' ),
			'date'          => esc_html__( 'Date', 'studiare-plus' ),
		);

		$columns = $columns + $new_columns;
		return $columns;
	}


	public function manage_html_blocks_columns( $column, $post_id ) {
		switch ( $column ) {
			case 'shortcode':
				echo '[html_block id="' . $post_id . '"]';
				break;
			case 'wd_categories':
				$terms     = wp_get_post_terms( $post_id, 'cms_block_cat' );
				$post_type = get_post_type( $post_id );
				$keys      = array_keys( $terms );
				$last_key  = end( $keys );

				if ( ! $terms ) {
					echo '—';
				}

				?>
				<?php foreach ( $terms as $key => $term ) : ?>
				<?php
				$name = $term->name;

				if ( $key !== $last_key ) {
					$name .= ',';
				}

				?>

				<a href="<?php echo esc_url( 'edit.php?post_type=' . $post_type . '&cms_block_cat=' . $term->slug ); ?>">
					<?php echo esc_html( $name ); ?>
				</a>
			<?php endforeach; ?>
				<?php
				break;
		}
	}


	// **********************************************************************//
	// ! Register Custom Post Type for Course lessons
	// **********************************************************************//
	
	public function register_lessons() {

	if ( function_exists( 'woodmart_get_opt' ) && ! woodmart_get_opt( 'course', '1' ) ) {
			return;
		}

		$labels = array(
			'name'          => esc_html__( 'جلسات دوره ها', 'studiare-plus' ),
			'singular_name' => esc_html__( 'جلسات دوره', 'studiare-plus' ),
			'menu_name'     => esc_html__( 'جلسات دوره', 'studiare-plus' ),
			'all_items'     => esc_html__( 'همه جلسات دوره ها', 'studiare-plus' ),
			'add_new'       => esc_html__( 'افزودن جلسات دوره', 'studiare-plus' ),
			'add_new_item'  => esc_html__( 'افزودن جلسات دوره', 'studiare-plus' ),
		);

		$args = array(
			'label'               => esc_html__( 'cms_lessons', 'studiare-plus' ),
			'description'         => esc_html__( 'جلسات دوره برای نمایش در صفحه محصولات', 'studiare-plus' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor' ),
			'hierarchical'        => false,
			'public'              => true,
			'publicly_queryable'  => is_user_logged_in(),
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'menu_position'       => 35,
			'menu_icon'           => 'dashicons-welcome-learn-more',
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'rewrite'             => false,
			'capability_type'     => 'page',
			'show_in_rest'        => true,
		);

		register_post_type( 'cms_lesson', $args );

		$labels = array(
			'name'                  => esc_html__( 'HTML Block categories', 'studiare-plus' ),
			'singular_name'         => esc_html__( 'HTML Block category', 'studiare-plus' ),
			'search_items'          => esc_html__( 'Search categories', 'studiare-plus' ),
			'popular_items'         => esc_html__( 'Popular categories', 'studiare-plus' ),
			'all_items'             => esc_html__( 'All categories', 'studiare-plus' ),
			'parent_item'           => esc_html__( 'Parent category', 'studiare-plus' ),
			'parent_item_colon'     => esc_html__( 'Parent category', 'studiare-plus' ),
			'edit_item'             => esc_html__( 'Edit category', 'studiare-plus' ),
			'update_item'           => esc_html__( 'Update category', 'studiare-plus' ),
			'add_new_item'          => esc_html__( 'Add New category', 'studiare-plus' ),
			'new_item_name'         => esc_html__( 'New category', 'studiare-plus' ),
			'add_or_remove_items'   => esc_html__( 'Add or remove categories', 'studiare-plus' ),
			'choose_from_most_used' => esc_html__( 'Choose from most used', 'studiare-plus' ),
			'menu_name'             => esc_html__( 'Categories', 'studiare-plus' ),
		);

		$args = array(
			'labels'            => $labels,
			'public'            => true,
			'show_in_nav_menus' => false,
			'show_admin_column' => false,
			'hierarchical'      => true,
			'show_tagcloud'     => true,
			'show_ui'           => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'cms_lesson_cat' ),
			'capabilities'      => array(),
			'default_term'      => array(
				'name' => esc_html__( 'دسته بندی نشده', 'studiare-plus' ),
				'slug' => 'uncategorized',
			),
			'show_in_rest'      => true,
		);

		register_taxonomy( 'cms_lesson_cat', array( 'cms_lesson' ), $args );
	}


	public function edit_html_lessons_columns( $columns ) {
		unset( $columns['date'] );

		$new_columns = array(
			'shortcode'     => esc_html__( 'Shortcode', 'studiare-plus' ),
			'wd_categories' => esc_html__( 'Categories', 'studiare-plus' ),
			'date'          => esc_html__( 'Date', 'studiare-plus' ),
		);

		$columns = $columns + $new_columns;
		return $columns;
	}


	public function manage_html_lessons_columns( $column, $post_id ) {
		switch ( $column ) {
			case 'shortcode':
				echo '[course_lesson id="' . $post_id . '"]';
				break;
			case 'wd_categories':
				$terms     = wp_get_post_terms( $post_id, 'cms_lesson_cat' );
				$post_type = get_post_type( $post_id );
				$keys      = array_keys( $terms );
				$last_key  = end( $keys );

				if ( ! $terms ) {
					echo '—';
				}

				?>
				<?php foreach ( $terms as $key => $term ) : ?>
				<?php
				$name = $term->name;

				if ( $key !== $last_key ) {
					$name .= ',';
				}

				?>

				<a href="<?php echo esc_url( 'edit.php?post_type=' . $post_type . '&cms_lesson_cat=' . $term->slug ); ?>">
					<?php echo esc_html( $name ); ?>
				</a>
			<?php endforeach; ?>
				<?php
				break;
		}
	}





	// **********************************************************************//
	// ! Register Custom Post Type for Course medals
	// **********************************************************************//
	
	public function register_medals() {

		if ( function_exists( 'woodmart_get_opt' ) && ! woodmart_get_opt( 'medal', '1' ) ) {
			return;
		}


		$labels = array(
			'name'          => esc_html__( 'مدال ها', 'studiare-plus' ),
			'singular_name' => esc_html__( 'مدال ها', 'studiare-plus' ),
			'menu_name'     => esc_html__( 'مدال ها', 'studiare-plus' ),
			'all_items'     => esc_html__( 'همه مدال ها', 'studiare-plus' ),
			'add_new'       => esc_html__( 'افزودن مدال', 'studiare-plus' ),
			'add_new_item'  => esc_html__( 'افزودن مدال', 'studiare-plus' ),
		);

		$args = array(
			'label'               => esc_html__( 'cms_medals', 'studiare-plus' ),
			'description'         => esc_html__( 'جلسات دوره برای نمایش در صفحه محصولات', 'studiare-plus' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'thumbnail' ),
			'hierarchical'        => false,
			'public'              => true,
			'publicly_queryable'  => is_user_logged_in(),
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'menu_position'       => 35,
			'menu_icon'           => 'dashicons-awards',
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'rewrite'             => false,
			'capability_type'     => 'page',
			'show_in_rest'        => true,
		);

		register_post_type( 'cms_medal', $args );

		$labels = array(
			'name'                  => esc_html__( 'HTML Block categories', 'studiare-plus' ),
			'singular_name'         => esc_html__( 'HTML Block category', 'studiare-plus' ),
			'search_items'          => esc_html__( 'Search categories', 'studiare-plus' ),
			'popular_items'         => esc_html__( 'Popular categories', 'studiare-plus' ),
			'all_items'             => esc_html__( 'All categories', 'studiare-plus' ),
			'parent_item'           => esc_html__( 'Parent category', 'studiare-plus' ),
			'parent_item_colon'     => esc_html__( 'Parent category', 'studiare-plus' ),
			'edit_item'             => esc_html__( 'Edit category', 'studiare-plus' ),
			'update_item'           => esc_html__( 'Update category', 'studiare-plus' ),
			'add_new_item'          => esc_html__( 'Add New category', 'studiare-plus' ),
			'new_item_name'         => esc_html__( 'New category', 'studiare-plus' ),
			'add_or_remove_items'   => esc_html__( 'Add or remove categories', 'studiare-plus' ),
			'choose_from_most_used' => esc_html__( 'Choose from most used', 'studiare-plus' ),
			'menu_name'             => esc_html__( 'Categories', 'studiare-plus' ),
		);

		$args = array(
			'labels'            => $labels,
			'public'            => true,
			'show_in_nav_menus' => false,
			'show_admin_column' => false,
			'hierarchical'      => true,
			'show_tagcloud'     => true,
			'show_ui'           => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'cms_medal_cat' ),
			'capabilities'      => array(),
			'default_term'      => array(
				'name' => esc_html__( 'دسته بندی نشده', 'studiare-plus' ),
				'slug' => 'uncategorized',
			),
			'show_in_rest'      => true,
		);

		register_taxonomy( 'cms_medal_cat', array( 'cms_medal' ), $args );
	}



	// **********************************************************************//
	// ! Register Custom Post Type for additional sidebars
	// **********************************************************************//
	public function register_sidebars() {

		$labels = array(
			'name'          => esc_html__( 'Sidebars', 'studiare-plus' ),
			'singular_name' => esc_html__( 'Sidebar', 'studiare-plus' ),
			'menu_name'     => esc_html__( 'Sidebars', 'studiare-plus' ),
			'all_items'     => esc_html__( 'All Sidebars', 'studiare-plus' ),
			'add_new'       => esc_html__( 'Add Sidebar', 'studiare-plus' ),
			'add_new_item'  => esc_html__( 'Add Sidebar', 'studiare-plus' ),
		);

		$args = array(
			'label'               => esc_html__( 'woodmart_sidebar', 'studiare-plus' ),
			'description'         => esc_html__( 'You can create additional custom sidebar and use them in Visual Composer', 'studiare-plus' ),
			'labels'              => $labels,
			'supports'            => array( 'title' ),
			'hierarchical'        => false,
			'public'              => false,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => false,
			'menu_position'       => 32,
			'menu_icon'           => 'dashicons-welcome-widgets-menus',
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'rewrite'             => false,
			'capability_type'     => 'page',
		);

		register_post_type( 'woodmart_sidebar', $args );

	}



	// **********************************************************************//
	// ! Register Custom Post Type for portfolio
	// **********************************************************************//
	public function register_portfolio() {
		if ( function_exists( 'woodmart_get_opt' ) && ! woodmart_get_opt( 'portfolio', '1' ) ) {
			return;
		}

		$portfolio_slug     = function_exists( 'woodmart_get_opt' ) ? woodmart_get_opt( 'portfolio_item_slug', 'portfolio' ) : 'portfolio';
		$portfolio_cat_slug = function_exists( 'woodmart_get_opt' ) ? woodmart_get_opt( 'portfolio_cat_slug', 'project-cat' ) : 'project-cat';
		$portfolio_page_id  = function_exists( 'woodmart_get_portfolio_page_id' ) ? woodmart_get_portfolio_page_id() : '';
		$has_archive        = $portfolio_page_id && get_post( $portfolio_page_id ) ? urldecode( get_page_uri( $portfolio_page_id ) ) : true;

		$labels = array(
			'name'          => esc_html__( 'Portfolio', 'studiare-plus' ),
			'singular_name' => esc_html__( 'Project', 'studiare-plus' ),
			'menu_name'     => esc_html__( 'Projects', 'studiare-plus' ),
			'all_items'     => esc_html__( 'All Projects', 'studiare-plus' ),
			'add_new'       => esc_html__( 'Add Project', 'studiare-plus' ),
			'add_new_item'  => esc_html__( 'Add Project', 'studiare-plus' ),
		);

		$args = array(
			'label'               => esc_html__( 'portfolio', 'studiare-plus' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments', 'page-attributes' ),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 32,
			'menu_icon'           => 'dashicons-format-gallery',
			'can_export'          => true,
			'has_archive'         => $has_archive,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'rewrite'             => array(
				'slug'       => $portfolio_slug,
				'with_front' => false,
				'feeds'      => true,
			),
			'capability_type'     => 'page',
			'show_in_rest'        => true,
		);

		register_post_type( 'portfolio', $args );

		/**
		 * Create a taxonomy category for portfolio
		 *
		 * @uses  Inserts new taxonomy object into the list
		 * @uses  Adds query vars
		 *
		 * @param string  Name of taxonomy object
		 * @param array|string  Name of the object type for the taxonomy object.
		 * @param array|string  Taxonomy arguments
		 * @return null|WP_Error WP_Error if errors, otherwise null.
		 */

		$labels = array(
			'name'                  => esc_html__( 'Project Categories', 'studiare-plus' ),
			'singular_name'         => esc_html__( 'Project Category', 'studiare-plus' ),
			'search_items'          => esc_html__( 'Search Categories', 'studiare-plus' ),
			'popular_items'         => esc_html__( 'Popular Project Categories', 'studiare-plus' ),
			'all_items'             => esc_html__( 'All Project Categories', 'studiare-plus' ),
			'parent_item'           => esc_html__( 'Parent Category', 'studiare-plus' ),
			'parent_item_colon'     => esc_html__( 'Parent Category', 'studiare-plus' ),
			'edit_item'             => esc_html__( 'Edit Category', 'studiare-plus' ),
			'update_item'           => esc_html__( 'Update Category', 'studiare-plus' ),
			'add_new_item'          => esc_html__( 'Add New Category', 'studiare-plus' ),
			'new_item_name'         => esc_html__( 'New Category', 'studiare-plus' ),
			'add_or_remove_items'   => esc_html__( 'Add or remove Categories', 'studiare-plus' ),
			'choose_from_most_used' => esc_html__( 'Choose from most used text-domain', 'studiare-plus' ),
			'menu_name'             => esc_html__( 'Categories', 'studiare-plus' ),
		);

		$args = array(
			'labels'            => $labels,
			'public'            => true,
			'show_in_nav_menus' => true,
			'show_admin_column' => false,
			'hierarchical'      => true,
			'show_tagcloud'     => true,
			'show_ui'           => true,
			'query_var'         => true,
			'rewrite'           => array(
				'slug'         => $portfolio_cat_slug,
				'with_front'   => false,
				'hierarchical' => true,
			),
			'capabilities'      => array(),
			'show_in_rest'      => true,
		);

		register_taxonomy( 'project-cat', array( 'portfolio' ), $args );

	}


	public function edit_woodmart_slide_columns( $columns ) {

		$columns = array(
			'cb'           => '<input type="checkbox" />',
			'thumb'        => '',
			'title'        => esc_html__( 'Title', 'studiare-plus' ),
			'slide-slider' => esc_html__( 'Slider', 'studiare-plus' ),
			'date'         => esc_html__( 'Date', 'studiare-plus' ),
		);

		return $columns;
	}


	public function manage_woodmart_slide_columns( $column, $post_id ) {
		switch ( $column ) {
			case 'thumb':
				$slide_image           = get_post_meta( $post_id, 'image', true );
				$meta_bg_image_desktop = get_post_meta( $post_id, 'bg_image_desktop', true );
				$meta_bg_slide_color   = get_post_meta( $post_id, 'bg_color', true );

				if ( ! empty( $slide_image['url'] ) ) {
					?>
					<img src="<?php echo esc_url( $slide_image['url'] ); ?>" alt="<?php echo esc_attr__( 'Slide thumbnail', 'studiare-plus' ); ?>">
					<?php
				} elseif ( $meta_bg_image_desktop && ! is_array( $meta_bg_image_desktop ) || ! empty( $meta_bg_image_desktop['url'] ) ) {
					if ( is_array( $meta_bg_image_desktop ) && isset( $meta_bg_image_desktop['url'] ) ) {
						$meta_bg_image_desktop = $meta_bg_image_desktop['url'];
					}
					?>
					<img src="<?php echo esc_url( $meta_bg_image_desktop ); ?>" alt="<?php echo esc_attr__( 'Slide thumbnail', 'studiare-plus' ); ?>">
					<?php
				} elseif ( has_post_thumbnail( $post_id ) ) {
					the_post_thumbnail( array( 60, 60 ) );
				} elseif ( $meta_bg_slide_color ) {
					?>
					<div class="xts-slider-bg-color" style="background-color: <?php echo esc_attr( $meta_bg_slide_color ); ?>"></div>
					<?php
				}

				break;
			case 'slide-slider':
				$terms    = wp_get_post_terms( $post_id, 'woodmart_slider' );
				$keys     = array_keys( $terms );
				$last_key = end( $keys );

				if ( ! $terms ) {
					echo '—';
				}

				?>
				<?php foreach ( $terms as $key => $term ) : ?>
					<?php
					$name = $term->name;

					if ( $key !== $last_key ) {
						$name .= ',';
					}

					?>
					<a href="<?php echo esc_url( get_edit_term_link( $term->term_id, 'woodmart_slider' ) ); ?>">
						<?php echo esc_html( $name ); ?>
					</a>
				<?php endforeach; ?>
				<?php

				break;
		}
	}



	public function edit_portfolio_columns( $columns ) {

		$columns = array(
			'cb'          => '<input type="checkbox" />',
			'thumb'       => '',
			'title'       => esc_html__( 'Title', 'studiare-plus' ),
			'project-cat' => esc_html__( 'Categories', 'studiare-plus' ),
			'date'        => esc_html__( 'Date', 'studiare-plus' ),
		);

		return $columns;
	}


	public function manage_portfolio_columns( $column, $post_id ) {
		switch ( $column ) {
			case 'thumb':
				if ( has_post_thumbnail( $post_id ) ) {
					the_post_thumbnail( array( 60, 60 ) );
				}
				break;
			case 'project-cat':
				$terms = get_the_terms( $post_id, 'project-cat' );

				if ( $terms && ! is_wp_error( $terms ) ) :

					$cats_links = array();

					foreach ( $terms as $term ) {
						$cats_links[] = $term->name;
					}

					$cats = join( ', ', $cats_links );
					?>
					
					<span><?php echo $cats; ?></span>
				
				<?php endif;
				break;
		}
	}

	/**
	 * Get the plugin url.
	 *
	 * @return string
	 */
	public function plugin_url() {
		return untrailingslashit( plugins_url( '/', __FILE__ ) );
	}

	/**
	 * Get the plugin path.
	 *
	 * @return string
	 */
	public function plugin_path() {
		return untrailingslashit( plugin_dir_path( __FILE__ ) );
	}


}

function WOODMART_Theme_Plugin() {
	return WOODMART_Post_Types::instance();
}

$GLOBALS['woodmart_theme_plugin'] = WOODMART_Theme_Plugin();

if ( ! function_exists( 'woodmart_compress' ) ) {
	function woodmart_compress( $variable ) {
		return base64_encode( $variable );
	}
}

if ( ! function_exists( 'woodmart_get_file' ) ) {
	function woodmart_get_file( $variable ) {
		return file_get_contents( $variable );
	}
}

if ( ! function_exists( 'woodmart_decompress' ) ) {
	function woodmart_decompress( $variable ) {
		return $variable ? base64_decode( $variable ) : '';
	}
}

if ( ! function_exists( 'woodmart_get_svg' ) ) {
	function woodmart_get_svg( $file ) {
		if ( ! apply_filters( 'woodmart_svg_cache', true ) ) {
			return file_get_contents( $file );
		}

		$file_path = array_reverse( explode( '/', $file ) );
		$slug      = 'wdm-svg-' . $file_path[2] . '-' . $file_path[1] . '-' . $file_path[0];
		$content   = get_transient( $slug );

		if ( ! $content ) {
			$file_get_contents = file_get_contents( $file );

			if ( strstr( $file_get_contents, '<svg' ) ) {
				$content = woodmart_compress( $file_get_contents );
				set_transient( $slug, $content, apply_filters( 'woodmart_svg_cache_time', 60 * 60 * 24 * 7 ) );
			}
		}

		return woodmart_decompress( $content );
	}
}

// **********************************************************************//
// ! It could be useful if you using nginx instead of apache
// **********************************************************************//

if ( ! function_exists( 'getallheaders' ) ) {
	function getallheaders() {
		$headers = array();
		foreach ( $_SERVER as $name => $value ) {
			if ( substr( $name, 0, 5 ) == 'HTTP_' ) {
				$headers[ str_replace( ' ', '-', ucwords( strtolower( str_replace( '_', ' ', substr( $name, 5 ) ) ) ) ) ] = $value;
			}
		}
		return $headers;
	}
}

// **********************************************************************//
// ! Support shortcodes in text widget
// **********************************************************************//

add_filter( 'widget_text', 'do_shortcode' );
?>
