<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Title
class studiare_Widget_Amarha extends Widget_Base {

   public function get_name() {
      return 'amar';
   }

   public function get_title() {
      return esc_html__( 'آمار', 'studiare-plus' );
   }

   public function get_icon() {
        return 'eicon-counter';
   }

   public function get_categories() {
      return [ 'studiare-elements' ];
   }

   protected function register_controls() {


     $this->start_controls_section(
        'amar_section',
        [
           'label' => esc_html__( 'تنظیمات عمومی', 'studiare-plus' ),
           'type' => Controls_Manager::SECTION,
        ]
     );

       $this->add_control(
			'amar_line_color',
			[
				'label'     => esc_html__( 'رنگ دلخواه', 'studiare-plus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
               '{{WRAPPER}} .amarleft ' => 'background-color: {{VALUE}}',
               '{{WRAPPER}} .amarbox i, .amarboxim h3 ' => 'color: {{VALUE}}',
				],
			]
		);


        $this->add_control(
            'clock_num',
            [
               'label' => __( 'تعداد ساعت', 'studiare-plus' ),
               'type' => \Elementor\Controls_Manager::TEXT,
 
            ]
         );



     $this->end_controls_section();


   }

   protected function render( $instance = [] ) {

    // get our input from the widget settings.
    $settings = $this->get_settings_for_display();

    // Element Class
    $count_courses = wp_count_posts( 'product' )->publish;
    $count_teacher = wp_count_posts( 'teacher' )->publish;

    $user_count_data = count_users();
    $total_users = $user_count_data['total_users'];



    ?>

<div class="amar">
  <div class="amarboxnew">
    <div class="amarbox">
      <i class="fal fa-books"></i>
      <div class="amarboxim">
        <h3>
          <?php echo $count_courses ; ?>
          <br />
          <strong>دوره آموزشی</strong>
        </h3>
      </div>
    </div>
  </div>

  <div class="amarboxnew">
    <div class="amarbox amarleft">
      <i class="fal fa-user-graduate"></i>
      <div class="amarboxim">
        <h3>
          <?php echo $total_users ; ?>
          <br />
          <strong>دانشجو</strong>
        </h3>
      </div>
    </div>
  </div>

  <div class="amarboxnew">
    <div class="amarbox">
      <i class="fal fa-alarm-clock"></i>
      <div class="amarboxim">
        <h3>
        <?php echo $settings['clock_num']; ?>
          ساعت<br />
          <strong>ساعت آموزش</strong>
        </h3>
      </div>
    </div>
  </div>

  <div class="amarboxnew">
    <div class="amarbox">
      <i class="fal fa-chalkboard-user"></i>
      <div class="amarboxim">
        <h3>
          <?php echo $count_teacher ; ?><br />
          <strong>تعداد اساتید</strong>
        </h3>
      </div>
    </div>
  </div>
</div>

   <?php }

}

Plugin::instance()->widgets_manager->register( new studiare_Widget_Amarha );

