<?php
/**
 * Post types file.
 *
 * @package Woodmart
 */

namespace WOODCORE;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Post types class.
 */
class Post_Types {
	/**
	 * Instance.
	 *
	 * @var null
	 */
	public static $instance = null;

	/**
	 * Instance.
	 *
	 * @return Post_Types|null
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'register_layout' ), 1 );
		add_action( 'init', array( $this, 'linked_variations' ), 1 );
		add_action( 'init', array( $this, 'bought_together' ), 1 );
		add_action( 'init', array( $this, 'register_discounts' ), 1 );
		add_action( 'init', array( $this, 'register_free_gifts' ), 1 );
		add_action( 'init', array( $this, 'register_estimate_delivery' ), 1 );
		add_action( 'init', array( $this, 'register_abandoned_cart' ), 1 );
		add_action( 'init', array( $this, 'register_custom_product_tabs' ), 1 );
		add_action( 'init', array( $this, 'register_popup_builder' ), 1 );
		add_action( 'init', array( $this, 'register_floating_blocks' ), 1 );
	}

	/**
	 * Register floating blocks post type.
	 */
	public function register_floating_blocks() {
		$labels = array(
			'name'          => esc_html__( 'Floating Blocks', 'studiare-plus' ),
			'singular_name' => esc_html__( 'Floating Block', 'studiare-plus' ),
			'menu_name'     => esc_html__( 'Floating Blocks', 'studiare-plus' ),
			'search_items'  => esc_html__( 'Search Blocks', 'studiare-plus' ),
			'all_items'     => esc_html__( 'All Blocks', 'studiare-plus' ),
			'add_new'       => esc_html__( 'Add Block', 'studiare-plus' ),
			'add_new_item'  => esc_html__( 'Add Block', 'studiare-plus' ),
		);

		$args = array(
			'label'               => esc_html__( 'Floating Blocks', 'studiare-plus' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'custom-fields' ),
			'hierarchical'        => false,
			'public'              => false,
			'publicly_queryable'  => is_user_logged_in(),
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => false,
			'menu_position'       => 37,
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'rewrite'             => false,
			'capability_type'     => 'page',
			'show_in_rest'        => true,
		);

		register_post_type( 'wd_floating_block', $args );

		$args = array(
			'public'            => true,
			'show_in_nav_menus' => false,
			'show_admin_column' => false,
			'hierarchical'      => true,
			'show_tagcloud'     => true,
			'show_ui'           => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'wd_floating_block_cat' ),
			'capabilities'      => array(),
			'show_in_rest'      => true,
			'default_term'      => array(
				'name' => esc_html__( 'Uncategorized', 'studiare-plus' ),
				'slug' => 'uncategorized',
			),
		);

		register_taxonomy( 'wd_floating_block_cat', array( 'wd_floating_block' ), $args );
	}

	/**
	 * Register popup builder post type.
	 */
	public function register_popup_builder() {
		$labels = array(
			'name'          => esc_html__( 'Popups', 'studiare-plus' ),
			'singular_name' => esc_html__( 'Popup', 'studiare-plus' ),
			'menu_name'     => esc_html__( 'Popups', 'studiare-plus' ),
			'search_items'  => esc_html__( 'Search Popup', 'studiare-plus' ),
			'all_items'     => esc_html__( 'All Popups', 'studiare-plus' ),
			'add_new'       => esc_html__( 'Add Popup', 'studiare-plus' ),
			'add_new_item'  => esc_html__( 'Add Popup', 'studiare-plus' ),
		);

		$args = array(
			'label'               => esc_html__( 'Popups', 'studiare-plus' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'custom-fields' ),
			'hierarchical'        => false,
			'public'              => false,
			'publicly_queryable'  => is_user_logged_in(),
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => false,
			'menu_position'       => 36,
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'rewrite'             => false,
			'capability_type'     => 'page',
			'show_in_rest'        => true,
		);

		register_post_type( 'wd_popup', $args );

		$args = array(
			'public'            => true,
			'show_in_nav_menus' => false,
			'show_admin_column' => false,
			'hierarchical'      => true,
			'show_tagcloud'     => true,
			'show_ui'           => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'wd_popup_cat' ),
			'capabilities'      => array(),
			'show_in_rest'      => true,
			'default_term'      => array(
				'name' => esc_html__( 'Uncategorized', 'studiare-plus' ),
				'slug' => 'uncategorized',
			),
		);

		register_taxonomy( 'wd_popup_cat', array( 'wd_popup' ), $args );
	}

	/**
	 * Register layout post type.
	 */
	public function register_layout() {
		register_post_type(
			'woodmart_layout',
			array(
				'label'               => esc_html__( 'Layouts', 'studiare-plus' ),
				'labels'              => array(
					'name'          => esc_html__( 'Layouts', 'studiare-plus' ),
					'singular_name' => esc_html__( 'Layout', 'studiare-plus' ),
					'menu_name'     => esc_html__( 'Layouts', 'studiare-plus' ),
					'all_items'     => esc_html__( 'All Layouts', 'studiare-plus' ),
					'add_new'       => esc_html__( 'Add Layout', 'studiare-plus' ),
					'add_new_item'  => esc_html__( 'Add Layout', 'studiare-plus' ),
				),
				'supports'            => array( 'title', 'editor' ),
				'show_in_nav_menus'   => false,
				'hierarchical'        => false,
				'public'              => true,
				'menu_position'       => 32,
				'menu_icon'           => 'dashicons-format-gallery',
				'publicly_queryable'  => is_user_logged_in(),
				'show_in_rest'        => true,
				'show_in_admin_bar'   => false,
				'capability_type'     => 'page',
				'exclude_from_search' => true,
			)
		);
	}

	/**
	 * Register layout post type.
	 */
	public function linked_variations() {
		if ( ! function_exists( 'woodmart_get_opt' ) || ( ! woodmart_get_opt( 'linked_variations' ) && ( ! function_exists( 'woodmart_is_import_demo_content' ) || ! woodmart_is_import_demo_content() ) ) ) {
			return;
		}

		register_post_type(
			'woodmart_woo_lv',
			array(
				'label'               => esc_html__( 'Linked Variations', 'studiare-plus' ),
				'labels'              => array(
					'name'          => esc_html__( 'Linked Variations', 'studiare-plus' ),
					'singular_name' => esc_html__( 'Linked Variations', 'studiare-plus' ),
					'menu_name'     => esc_html__( 'Linked Variations', 'studiare-plus' ),
					'add_new'       => esc_html__( 'Add New', 'studiare-plus' ),
					'add_new_item'  => esc_html__( 'Add New', 'studiare-plus' ),
				),
				'supports'            => array( 'title' ),
				'show_in_nav_menus'   => false,
				'hierarchical'        => false,
				'public'              => false,
				'show_ui'             => true,
				'show_in_menu'        => 'edit.php?post_type=product',
				'publicly_queryable'  => false,
				'show_in_rest'        => true,
				'show_in_admin_bar'   => false,
				'capability_type'     => 'product',
				'exclude_from_search' => true,
			)
		);
	}

	/**
	 * Register frequently bought together post type.
	 */
	public function bought_together() {
		if ( ! function_exists( 'woodmart_get_opt' ) || ( ! woodmart_get_opt( 'bought_together_enabled' ) && ( ! function_exists( 'woodmart_is_import_demo_content' ) || ! woodmart_is_import_demo_content() ) ) ) {
			return;
		}

		register_post_type(
			'woodmart_woo_fbt',
			array(
				'label'               => esc_html__( 'Frequently Bought Together', 'studiare-plus' ),
				'labels'              => array(
					'name'          => esc_html__( 'Frequently Bought Together', 'studiare-plus' ),
					'singular_name' => esc_html__( 'Frequently Bought Together', 'studiare-plus' ),
					'menu_name'     => esc_html__( 'Frequently Bought Together', 'studiare-plus' ),
					'add_new'       => esc_html__( 'Add New', 'studiare-plus' ),
					'add_new_item'  => esc_html__( 'Add New', 'studiare-plus' ),
				),
				'supports'            => array( 'title' ),
				'show_in_nav_menus'   => false,
				'hierarchical'        => false,
				'public'              => false,
				'show_ui'             => true,
				'show_in_menu'        => 'edit.php?post_type=product',
				'publicly_queryable'  => false,
				'show_in_rest'        => true,
				'show_in_admin_bar'   => false,
				'capability_type'     => 'product',
				'exclude_from_search' => true,
			)
		);
	}

	/**
	 * Register Dynamic Pricing & Discounts post type.
	 */
	public function register_discounts() {
		if ( ! function_exists( 'woodmart_get_opt' ) || ( ! woodmart_get_opt( 'discounts_enabled' ) && ( ! function_exists( 'woodmart_is_import_demo_content' ) || ! woodmart_is_import_demo_content() ) ) ) {
			return;
		}

		register_post_type(
			'wd_woo_discounts',
			array(
				'label'               => esc_html__( 'Dynamic Discounts', 'studiare-plus' ),
				'labels'              => array(
					'name'          => esc_html__( 'Dynamic Discounts', 'studiare-plus' ),
					'singular_name' => esc_html__( 'Dynamic Discount', 'studiare-plus' ),
					'menu_name'     => esc_html__( 'Dynamic Discounts', 'studiare-plus' ),
					'add_new'       => esc_html__( 'Add New', 'studiare-plus' ),
					'add_new_item'  => esc_html__( 'Add New Rule', 'studiare-plus' ),
					'edit_item'     => esc_html__( 'Edit Discount Rule', 'studiare-plus' ),
				),
				'supports'            => array( 'title' ),
				'show_in_nav_menus'   => false,
				'hierarchical'        => false,
				'public'              => false,
				'show_ui'             => true,
				'show_in_menu'        => 'edit.php?post_type=product',
				'publicly_queryable'  => false,
				'show_in_rest'        => true,
				'capability_type'     => 'product',
				'exclude_from_search' => true,
			)
		);
	}

	/**
	 * Register Free gifts post type.
	 */
	public function register_free_gifts() {
		if ( ! function_exists( 'woodmart_get_opt' ) || ( ! woodmart_get_opt( 'free_gifts_enabled' ) && ( ! function_exists( 'woodmart_is_import_demo_content' ) || ! woodmart_is_import_demo_content() ) ) ) {
			return;
		}

		register_post_type(
			'wd_woo_free_gifts',
			array(
				'label'               => esc_html__( 'Free Gifts', 'studiare-plus' ),
				'labels'              => array(
					'name'          => esc_html__( 'Free Gifts', 'studiare-plus' ),
					'singular_name' => esc_html__( 'Free Gift', 'studiare-plus' ),
					'menu_name'     => esc_html__( 'Free Gifts', 'studiare-plus' ),
					'add_new'       => esc_html__( 'Add New', 'studiare-plus' ),
					'add_new_item'  => esc_html__( 'Add New Gift', 'studiare-plus' ),
					'edit_item'     => esc_html__( 'Edit Gift Rule', 'studiare-plus' ),
				),
				'supports'            => array( 'title' ),
				'show_in_nav_menus'   => false,
				'hierarchical'        => false,
				'public'              => false,
				'show_ui'             => true,
				'show_in_menu'        => 'edit.php?post_type=product',
				'publicly_queryable'  => false,
				'show_in_rest'        => true,
				'capability_type'     => 'product',
				'exclude_from_search' => true,
			)
		);
	}

	/**
	 * Register Estimate Delivery post type.
	 */
	public function register_estimate_delivery() {
		if ( ! function_exists( 'woodmart_get_opt' ) || ( ! woodmart_get_opt( 'estimate_delivery_enabled' ) && ( ! function_exists( 'woodmart_is_import_demo_content' ) || ! woodmart_is_import_demo_content() ) ) ) {
			return;
		}

		register_post_type(
			'wd_woo_est_del',
			array(
				'label'               => esc_html__( 'Estimate Delivery', 'studiare-plus' ),
				'labels'              => array(
					'name'          => esc_html__( 'Estimate Delivery', 'studiare-plus' ),
					'singular_name' => esc_html__( 'Estimate Delivery', 'studiare-plus' ),
					'menu_name'     => esc_html__( 'Estimate Delivery', 'studiare-plus' ),
					'add_new'       => esc_html__( 'Add New', 'studiare-plus' ),
					'add_new_item'  => esc_html__( 'Add New Rule', 'studiare-plus' ),
					'edit_item'     => esc_html__( 'Edit Estimate Delivery Rule', 'studiare-plus' ),
				),
				'supports'            => array( 'title' ),
				'show_in_nav_menus'   => false,
				'hierarchical'        => false,
				'public'              => false,
				'show_ui'             => true,
				'show_in_menu'        => 'edit.php?post_type=product',
				'publicly_queryable'  => false,
				'show_in_rest'        => true,
				'capability_type'     => 'product',
				'exclude_from_search' => true,
			)
		);
	}

	/**
	 * Register Abandoned Cart post type.
	 */
	public function register_abandoned_cart() {
		if ( ! function_exists( 'woodmart_get_opt' ) || ! woodmart_get_opt( 'cart_recovery_enabled' ) ) {
			return;
		}

		register_post_type(
			'wd_abandoned_cart',
			array(
				'label'               => esc_html__( 'Carts', 'studiare-plus' ),
				'labels'              => array(
					'name'          => esc_html__( 'Abandoned Cart', 'studiare-plus' ),
					'singular_name' => esc_html__( 'Abandoned Cart', 'studiare-plus' ),
					'menu_name'     => esc_html__( 'Abandoned Cart', 'studiare-plus' ),
					'add_new'       => esc_html__( 'Add New Abandoned Cart', 'studiare-plus' ),
					'add_new_item'  => esc_html__( 'Add New Abandoned Cart', 'studiare-plus' ),
					'edit_item'     => esc_html__( 'Abandoned cart information', 'studiare-plus' ),
				),
				'supports'            => array( '' ),
				'show_in_nav_menus'   => false,
				'hierarchical'        => false,
				'public'              => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'capabilities'        => array( 'create_posts' => false ),
				'map_meta_cap'        => true,
			)
		);
	}

	/**
	 * Register custom product tabs.
	 */
	public function register_custom_product_tabs() {
		if ( ! function_exists( 'woodmart_get_opt' ) || ( ! woodmart_get_opt( 'custom_product_tabs_enabled' ) && ( ! function_exists( 'woodmart_is_import_demo_content' ) || ! woodmart_is_import_demo_content() ) ) ) {
			return;
		}

		register_post_type(
			'wd_product_tabs',
			array(
				'label'               => esc_html__( 'Custom Tabs', 'studiare-plus' ),
				'labels'              => array(
					'name'          => esc_html__( 'Custom Tabs', 'studiare-plus' ),
					'singular_name' => esc_html__( 'Custom Tabs', 'studiare-plus' ),
					'menu_name'     => esc_html__( 'Custom Tabs', 'studiare-plus' ),
					'add_new'       => esc_html__( 'Add New Tab', 'studiare-plus' ),
					'add_new_item'  => esc_html__( 'Add New Tab', 'studiare-plus' ),
					'edit_item'     => esc_html__( 'Edit Tabs', 'studiare-plus' ),
				),
				'supports'            => array( 'title', 'editor' ),
				'show_in_nav_menus'   => false,
				'hierarchical'        => false,
				'public'              => false,
				'show_in_admin_bar'   => false,
				'show_in_menu'        => 'edit.php?post_type=product',
				'publicly_queryable'  => is_user_logged_in(),
				'show_in_rest'        => true,
				'capability_type'     => 'product',
				'exclude_from_search' => true,
				'show_ui'             => true,
				'rewrite'             => false,
			)
		);
	}
}

Post_Types::get_instance();











